/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.opennms.netmgt.model.OnmsMapElement;

@XmlRootElement(name="map")
@Entity
@Table(name="map")
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsMap
implements Serializable {
    private static final long serialVersionUID = 3885485728813867167L;
    public static final String USER_GENERATED_MAP = "U";
    public static final String AUTOMATICALLY_GENERATED_MAP = "A";
    public static final String AUTOMATIC_SAVED_MAP = "S";
    public static final String DELETED_MAP = "D";
    public static final String ACCESS_MODE_ADMIN = "RW";
    public static final String ACCESS_MODE_USER = "RO";
    public static final String ACCESS_MODE_GROUP = "RWRO";
    private int id;
    private String name;
    private String mapGroup;
    private String background;
    private String owner;
    private String accessMode;
    private String userLastModifies;
    private Date createTime;
    private Date lastModifiedTime;
    private float scale;
    private int offsetX;
    private int offsetY;
    private String type;
    private int width;
    private int height;
    private Set<OnmsMapElement> mapElements = new LinkedHashSet<OnmsMapElement>();

    public OnmsMap() {
        this.createTime = new Date();
        this.lastModifiedTime = new Date();
    }

    public OnmsMap(String name, String owner) {
        this.name = name;
        this.owner = owner;
        this.userLastModifies = owner;
        this.createTime = new Date();
        this.lastModifiedTime = new Date();
        this.accessMode = ACCESS_MODE_USER;
        this.type = USER_GENERATED_MAP;
        this.width = 800;
        this.height = 600;
    }

    public OnmsMap(String name, String owner, int width, int height) {
        this.name = name;
        this.owner = owner;
        this.userLastModifies = owner;
        this.createTime = new Date();
        this.lastModifiedTime = new Date();
        this.accessMode = ACCESS_MODE_USER;
        this.type = USER_GENERATED_MAP;
        this.width = width;
        this.height = height;
    }

    public OnmsMap(String name, String owner, String accessMode, int width, int height) {
        this.name = name;
        this.owner = owner;
        this.userLastModifies = owner;
        this.createTime = new Date();
        this.lastModifiedTime = new Date();
        this.setAccessMode(accessMode);
        this.type = USER_GENERATED_MAP;
        this.width = width;
        this.height = height;
    }

    public OnmsMap(String name, String mapGroup, String background, String owner, String accessMode, String type, int width, int height) {
        this.name = name;
        this.mapGroup = mapGroup;
        this.background = background;
        this.owner = owner;
        this.userLastModifies = owner;
        this.createTime = new Date();
        this.lastModifiedTime = new Date();
        this.setAccessMode(accessMode);
        this.setType(type);
        this.width = width;
        this.height = height;
    }

    @XmlTransient
    @Id
    @Column(name="mapId", nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public int getId() {
        return this.id;
    }

    @XmlID
    @Transient
    public String getMapId() {
        return Integer.toString(this.getId());
    }

    public void setId(int id) {
        this.id = id;
    }

    @Column(name="mapName")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="mapGroup")
    public String getMapGroup() {
        return this.mapGroup;
    }

    public void setMapGroup(String mapGroup) {
        this.mapGroup = mapGroup;
    }

    @Column(name="mapBackGround")
    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    @Column(name="mapOwner")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Column(name="mapAccess")
    public String getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(String accessMode) {
        this.accessMode = accessMode.trim().equalsIgnoreCase(ACCESS_MODE_GROUP) ? ACCESS_MODE_GROUP : ACCESS_MODE_ADMIN;
    }

    @Column(name="userLastModifies")
    public String getUserLastModifies() {
        return this.userLastModifies;
    }

    public void setUserLastModifies(String userLastModifies) {
        this.userLastModifies = userLastModifies;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="mapCreateTime")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastModifiedTime")
    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Column(name="mapScale")
    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    @Column(name="mapXOffset")
    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    @Column(name="mapYOffset")
    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    @Column(name="mapType")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type.equalsIgnoreCase(AUTOMATICALLY_GENERATED_MAP) ? AUTOMATICALLY_GENERATED_MAP : (type.equalsIgnoreCase(AUTOMATIC_SAVED_MAP) ? AUTOMATIC_SAVED_MAP : USER_GENERATED_MAP);
    }

    @Column(name="mapWidth")
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Column(name="mapHeight")
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @XmlTransient
    @OneToMany(mappedBy="map")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<OnmsMapElement> getMapElements() {
        return this.mapElements;
    }

    public void setMapElements(Set<OnmsMapElement> mapElements) {
        this.mapElements = mapElements;
    }

    public void addMapElement(OnmsMapElement element) {
        element.setMap(this);
        this.getMapElements().add(element);
    }
}

