/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.sampler;

import java.io.File;
import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.api.sample.Agent;
import org.opennms.netmgt.collection.api.CollectionAgent;

public class SamplerCollectionAgent
implements CollectionAgent {
    private final Agent m_agent;

    public SamplerCollectionAgent(Agent agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Agent value cannot be null");
        }
        this.m_agent = agent;
    }

    public Boolean isStoreByForeignSource() {
        return false;
    }

    public String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.m_agent.getInetAddress());
    }

    public void setSavedIfCount(int ifCount) {
    }

    public int getNodeId() {
        Integer nodeId = this.m_agent.getNodeId();
        if (nodeId != null) {
            return nodeId;
        }
        return -1;
    }

    public String getForeignSource() {
        return this.m_agent.getForeignSource();
    }

    public String getForeignId() {
        return this.m_agent.getForeignId();
    }

    public File getStorageDir() {
        int nodeId = this.getNodeId();
        if (nodeId > 0) {
            return new File(String.valueOf(nodeId));
        }
        return null;
    }

    public String getSysObjectId() {
        return (String)this.m_agent.getParameters().get("sysObjectId");
    }

    public String toString() {
        return super.toString();
    }

    public long getSavedSysUpTime() {
        return 0L;
    }

    public void setSavedSysUpTime(long sysUpTime) {
    }

    public int getType() {
        return 1;
    }

    public InetAddress getAddress() {
        return this.m_agent.getInetAddress();
    }

    public <V> V getAttribute(String property) {
        return (V)this.m_agent.getParameter(property);
    }

    public Object setAttribute(String property, Object value) {
        return null;
    }
}

