/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.snmp.internal;

import org.opennms.netmgt.api.sample.SampleSet;
import org.opennms.netmgt.api.sample.Timestamp;
import org.opennms.netmgt.sampler.config.snmp.SnmpAgent;
import org.opennms.netmgt.sampler.config.snmp.SnmpCollectionRequest;
import org.opennms.netmgt.sampler.snmp.CollectionException;
import org.opennms.netmgt.sampler.snmp.SnmpCollector;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSnmpCollector
implements SnmpCollector {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSnmpCollector.class);

    @Override
    public SampleSet collect(SnmpCollectionRequest request) throws Exception {
        SampleSet sampleSet = new SampleSet(Timestamp.now());
        SnmpAgentConfig agentConfig = request.getAgentConfig();
        SnmpAgent agent = request.getAgent();
        CollectionTracker collectionTracker = request.getCollectionTracker(sampleSet);
        LOG.debug("collect: tracker = {}, agent = {}, agentConfig = {}", new Object[]{collectionTracker, agent, agentConfig});
        try {
            SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)agent.getId(), (CollectionTracker)collectionTracker);
            walker.start();
            walker.waitFor();
            if (!walker.timedOut() && walker.failed()) {
                throw new CollectionException(walker.getErrorThrowable());
            }
            return sampleSet;
        }
        catch (CollectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CollectionException(e);
        }
    }
}

