/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.minion.api.MapAdapter;
import org.opennms.minion.api.MinionException;
import org.opennms.minion.api.MinionMessage;

public abstract class AbstractMinionMessage
implements MinionMessage {
    @XmlAttribute(name="version")
    private Integer m_version;
    @XmlElement(name="properties")
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    private Map<String, String> m_properties;

    protected AbstractMinionMessage() {
    }

    public AbstractMinionMessage(Integer version) throws MinionException {
        if (version == null) {
            throw new MinionException("Message version must be defined!");
        }
        this.m_version = version;
    }

    public int getVersion() {
        return this.m_version;
    }

    public Map<String, String> getProperties() {
        if (this.m_properties != null) {
            return Collections.unmodifiableMap(this.m_properties);
        }
        return Collections.emptyMap();
    }

    public void addProperty(String key, String value) {
        this.assertPropertiesCreated();
        this.m_properties.put(key, value);
    }

    private void assertPropertiesCreated() {
        if (this.m_properties == null) {
            this.m_properties = new LinkedHashMap<String, String>();
        }
    }
}

