/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedId;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.policies.RetryPolicy;
import java.nio.ByteBuffer;
import java.util.List;

public class DefaultPreparedStatement
implements PreparedStatement {
    final PreparedId preparedId;
    final String query;
    final String queryKeyspace;
    volatile ByteBuffer routingKey;
    volatile ConsistencyLevel consistency;
    volatile ConsistencyLevel serialConsistency;
    volatile boolean traceQuery;
    volatile RetryPolicy retryPolicy;

    private DefaultPreparedStatement(PreparedId id, String query, String queryKeyspace) {
        this.preparedId = id;
        this.query = query;
        this.queryKeyspace = queryKeyspace;
    }

    static DefaultPreparedStatement fromMessage(Responses.Result.Prepared msg, Metadata clusterMetadata, int protocolVersion, String query, String queryKeyspace) {
        TableMetadata tm;
        assert (msg.metadata.columns != null);
        ColumnDefinitions defs = msg.metadata.columns;
        if (defs.size() == 0) {
            return new DefaultPreparedStatement(new PreparedId(msg.statementId, defs, msg.resultMetadata.columns, null, protocolVersion), query, queryKeyspace);
        }
        List<ColumnMetadata> partitionKeyColumns = null;
        int[] pkIndexes = null;
        KeyspaceMetadata km = clusterMetadata.getKeyspace(defs.getKeyspace(0));
        if (km != null && (tm = km.getTable(defs.getTable(0))) != null) {
            partitionKeyColumns = tm.getPartitionKey();
            pkIndexes = new int[partitionKeyColumns.size()];
            for (int i = 0; i < pkIndexes.length; ++i) {
                pkIndexes[i] = -1;
            }
        }
        for (int i = 0; i < defs.size(); ++i) {
            DefaultPreparedStatement.maybeGetIndex(defs.getName(i), i, partitionKeyColumns, pkIndexes);
        }
        PreparedId prepId = new PreparedId(msg.statementId, defs, msg.resultMetadata.columns, (int[])(DefaultPreparedStatement.allSet(pkIndexes) ? pkIndexes : null), protocolVersion);
        return new DefaultPreparedStatement(prepId, query, queryKeyspace);
    }

    private static void maybeGetIndex(String name, int j, List<ColumnMetadata> pkColumns, int[] pkIndexes) {
        if (pkColumns == null) {
            return;
        }
        for (int i = 0; i < pkColumns.size(); ++i) {
            if (!name.equals(pkColumns.get(i).getName())) continue;
            pkIndexes[i] = j;
            return;
        }
    }

    private static boolean allSet(int[] pkColumns) {
        if (pkColumns == null) {
            return false;
        }
        for (int i = 0; i < pkColumns.length; ++i) {
            if (pkColumns[i] >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public ColumnDefinitions getVariables() {
        return this.preparedId.metadata;
    }

    @Override
    public BoundStatement bind(Object ... values) {
        BoundStatement bs = new BoundStatement(this);
        return bs.bind(values);
    }

    @Override
    public BoundStatement bind() {
        return new BoundStatement(this);
    }

    @Override
    public PreparedStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    @Override
    public PreparedStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = SimpleStatement.compose(routingKeyComponents);
        return this;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        return this.routingKey;
    }

    @Override
    public PreparedStatement setConsistencyLevel(ConsistencyLevel consistency) {
        this.consistency = consistency;
        return this;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    @Override
    public PreparedStatement setSerialConsistencyLevel(ConsistencyLevel serialConsistency) {
        if (serialConsistency != ConsistencyLevel.SERIAL && serialConsistency != ConsistencyLevel.LOCAL_SERIAL) {
            throw new IllegalArgumentException();
        }
        this.serialConsistency = serialConsistency;
        return this;
    }

    @Override
    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistency;
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    @Override
    public String getQueryKeyspace() {
        return this.queryKeyspace;
    }

    @Override
    public PreparedStatement enableTracing() {
        this.traceQuery = true;
        return this;
    }

    @Override
    public PreparedStatement disableTracing() {
        this.traceQuery = false;
        return this;
    }

    @Override
    public boolean isTracing() {
        return this.traceQuery;
    }

    @Override
    public PreparedStatement setRetryPolicy(RetryPolicy policy) {
        this.retryPolicy = policy;
        return this;
    }

    @Override
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public PreparedId getPreparedId() {
        return this.preparedId;
    }
}

