/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.storage.newts;

import com.google.common.primitives.UnsignedLong;
import java.math.BigInteger;
import org.opennms.netmgt.api.sample.Sample;
import org.opennms.netmgt.api.sample.SampleSet;
import org.opennms.netmgt.api.sample.SampleSetDispatcher;
import org.opennms.netmgt.api.sample.SampleValue;
import org.opennms.netmgt.sampler.storage.newts.NewtsRepositoryAdapter;

public class NewtsSampleSetDispatcher
implements SampleSetDispatcher {
    private NewtsRepositoryAdapter m_newtsRepository;

    public NewtsSampleSetDispatcher(NewtsRepositoryAdapter newtsRepository) {
        this.m_newtsRepository = newtsRepository;
    }

    private UnsignedLong toUnsignedLong(SampleValue<?> value) {
        return UnsignedLong.valueOf((BigInteger)value.bigIntegerValue());
    }

    public void save(SampleSet sampleSet) {
        try (NewtsRepositoryAdapter.Batch batch = this.m_newtsRepository.createBatch();){
            for (Sample sample : sampleSet.getSamples()) {
                long millis = sample.getTimestamp().asMillis();
                String resource = sample.getResource().getIdentifier();
                String metricName = sample.getMetric().getName();
                SampleValue value = sample.getValue();
                switch (sample.getMetric().getType()) {
                    case ABSOLUTE: {
                        batch.absolute(millis, resource, metricName, this.toUnsignedLong(value));
                        break;
                    }
                    case COUNTER: {
                        batch.counter(millis, resource, metricName, this.toUnsignedLong(value));
                        break;
                    }
                    case DERIVE: {
                        batch.derive(millis, resource, metricName, this.toUnsignedLong(value));
                        break;
                    }
                    case GAUGE: {
                        batch.gauge(millis, resource, metricName, value.doubleValue());
                    }
                }
            }
        }
    }
}

