/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.storage.newts;

import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedLong;
import java.util.List;
import org.opennms.newts.api.Absolute;
import org.opennms.newts.api.Counter;
import org.opennms.newts.api.Derive;
import org.opennms.newts.api.Gauge;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;

public class NewtsRepositoryAdapter {
    SampleRepository m_repository;

    public NewtsRepositoryAdapter(SampleRepository repository) {
        this.m_repository = repository;
    }

    Batch createBatch() {
        return new Batch();
    }

    public class Batch
    implements AutoCloseable {
        List<Sample> m_samples = Lists.newArrayList();

        private void add(Sample s) {
            this.m_samples.add(s);
        }

        public void gauge(long millis, String resource, String name, double value) {
            this.add(new Sample(Timestamp.fromEpochMillis((long)millis), new Resource(resource), name, MetricType.GAUGE, (ValueType)new Gauge(value)));
        }

        public void derive(long millis, String resource, String name, UnsignedLong value) {
            this.add(new Sample(Timestamp.fromEpochMillis((long)millis), new Resource(resource), name, MetricType.DERIVE, (ValueType)new Derive(value)));
        }

        public void absolute(long millis, String resource, String name, UnsignedLong value) {
            this.add(new Sample(Timestamp.fromEpochMillis((long)millis), new Resource(resource), name, MetricType.GAUGE, (ValueType)new Absolute(value)));
        }

        public void counter(long millis, String resource, String name, UnsignedLong value) {
            this.add(new Sample(Timestamp.fromEpochMillis((long)millis), new Resource(resource), name, MetricType.COUNTER, (ValueType)new Counter(value)));
        }

        public void save() {
            NewtsRepositoryAdapter.this.m_repository.insert(this.m_samples);
            this.m_samples = null;
        }

        @Override
        public void close() {
            this.save();
        }
    }
}

