/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.security.impl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import org.apache.felix.gogo.api.CommandSessionListener;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredCommandProcessorImpl
extends CommandProcessorImpl {
    private final BundleContext bundleContext;
    private final ServiceTracker<Object, Object> commandTracker;
    private final ServiceTracker<Converter, Converter> converterTracker;
    private final ServiceTracker<CommandSessionListener, CommandSessionListener> listenerTracker;

    public SecuredCommandProcessorImpl(BundleContext bc, ThreadIO io) {
        super(io);
        this.bundleContext = bc;
        String roleClause = "";
        AccessControlContext acc = AccessController.getContext();
        Subject sub = Subject.getSubject(acc);
        if (sub != null) {
            Set<RolePrincipal> rolePrincipals = sub.getPrincipals(RolePrincipal.class);
            if (rolePrincipals.size() == 0) {
                throw new SecurityException("Current user has no associated roles.");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("(|");
            for (RolePrincipal rp : rolePrincipals) {
                sb.append('(');
                sb.append("org.apache.karaf.service.guard.roles");
                sb.append('=');
                sb.append(rp.getName());
                sb.append(')');
            }
            sb.append("(!(org.apache.karaf.service.guard.roles=*))");
            sb.append(')');
            roleClause = sb.toString();
        }
        this.addConstant(".context", bc);
        this.addCommand("osgi", (Object)this, "addCommand");
        this.addCommand("osgi", (Object)this, "removeCommand");
        this.addCommand("osgi", (Object)this, "eval");
        try {
            this.commandTracker = this.trackCommands(bc, roleClause);
            this.commandTracker.open();
            this.converterTracker = this.trackConverters(bc);
            this.converterTracker.open();
            this.listenerTracker = this.trackListeners(bc);
            this.listenerTracker.open();
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.commandTracker.close();
        this.converterTracker.close();
        this.listenerTracker.close();
    }

    private ServiceTracker<Object, Object> trackCommands(BundleContext context, String roleClause) throws InvalidSyntaxException {
        Filter filter = context.createFilter(String.format("(&(%s=*)(%s=*)%s)", "osgi.command.scope", "osgi.command.function", roleClause));
        return new ServiceTracker<Object, Object>(context, filter, null){
            private final ConcurrentMap<ServiceReference, Map<String, CommandProxy>> proxies;
            {
                this.proxies = new ConcurrentHashMap<ServiceReference, Map<String, CommandProxy>>();
            }

            public Object addingService(ServiceReference reference) {
                Object scope = reference.getProperty("osgi.command.scope");
                Object function = reference.getProperty("osgi.command.function");
                Object ranking = reference.getProperty("service.ranking");
                ArrayList<CommandProxy> commands = new ArrayList<CommandProxy>();
                int rank = 0;
                if (ranking != null) {
                    try {
                        rank = Integer.parseInt(ranking.toString());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (scope != null && function != null) {
                    HashMap<String, CommandProxy> proxyMap = new HashMap<String, CommandProxy>();
                    if (function.getClass().isArray()) {
                        for (Object f : (Object[])function) {
                            CommandProxy target = new CommandProxy(this.context, reference, f.toString());
                            proxyMap.put(f.toString(), target);
                            SecuredCommandProcessorImpl.this.addCommand(scope.toString(), (Object)target, f.toString(), rank);
                            commands.add(target);
                        }
                    } else {
                        CommandProxy target = new CommandProxy(this.context, reference, function.toString());
                        proxyMap.put(function.toString(), target);
                        SecuredCommandProcessorImpl.this.addCommand(scope.toString(), (Object)target, function.toString(), rank);
                        commands.add(target);
                    }
                    this.proxies.put(reference, proxyMap);
                    return commands;
                }
                return null;
            }

            public void removedService(ServiceReference reference, Object service) {
                Object scope = reference.getProperty("osgi.command.scope");
                Object function = reference.getProperty("osgi.command.function");
                if (scope != null && function != null) {
                    Map proxyMap = (Map)this.proxies.remove(reference);
                    for (Map.Entry entry : proxyMap.entrySet()) {
                        SecuredCommandProcessorImpl.this.removeCommand(scope.toString(), (String)entry.getKey(), entry.getValue());
                    }
                }
                super.removedService(reference, service);
            }
        };
    }

    private ServiceTracker<Converter, Converter> trackConverters(BundleContext context) {
        return new ServiceTracker<Converter, Converter>(context, Converter.class.getName(), null){

            public Converter addingService(ServiceReference<Converter> reference) {
                Converter converter = (Converter)super.addingService(reference);
                SecuredCommandProcessorImpl.this.addConverter(converter);
                return converter;
            }

            public void removedService(ServiceReference<Converter> reference, Converter service) {
                SecuredCommandProcessorImpl.this.removeConverter(service);
                super.removedService(reference, (Object)service);
            }
        };
    }

    private ServiceTracker<CommandSessionListener, CommandSessionListener> trackListeners(BundleContext context) {
        return new ServiceTracker<CommandSessionListener, CommandSessionListener>(context, CommandSessionListener.class.getName(), null){

            public CommandSessionListener addingService(ServiceReference<CommandSessionListener> reference) {
                CommandSessionListener listener = (CommandSessionListener)super.addingService(reference);
                SecuredCommandProcessorImpl.this.addListener(listener);
                return listener;
            }

            public void removedService(ServiceReference<CommandSessionListener> reference, CommandSessionListener service) {
                SecuredCommandProcessorImpl.this.removeListener(service);
                super.removedService(reference, (Object)service);
            }
        };
    }
}

