/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.api.sample.SampleSet;
import org.opennms.netmgt.api.sample.SampleValue;
import org.opennms.netmgt.config.api.collection.IColumn;
import org.opennms.netmgt.config.api.collection.ITable;
import org.opennms.netmgt.sampler.config.snmp.Column;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionInitializationCache;
import org.opennms.netmgt.sampler.config.snmp.ResourceType;
import org.opennms.netmgt.sampler.config.snmp.SnmpAgent;
import org.opennms.netmgt.sampler.config.snmp.SnmpCollectionRequest;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="table")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Table
implements ITable {
    private static final Logger LOG = LoggerFactory.getLogger(Table.class);
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="instance")
    private String m_instance;
    @XmlElement(name="column")
    private Column[] m_columns;
    @XmlTransient
    private ResourceType m_resourceType;

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getInstance() {
        return this.m_instance;
    }

    public void setInstance(String instance) {
        this.m_instance = instance;
    }

    public IColumn[] getColumns() {
        return this.m_columns;
    }

    public void setColumns(IColumn[] columns) {
        if (columns == null) {
            this.m_columns = null;
            return;
        }
        Column[] newColumns = new Column[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            newColumns[i] = Column.asColumn(columns[i]);
        }
        this.m_columns = newColumns;
    }

    public void initialize(DataCollectionInitializationCache cache) {
        LOG.debug("{} initializing (instance={})", (Object)this.m_name, (Object)this.m_instance);
        this.m_resourceType = cache.getType(this.m_instance);
        LOG.debug("{} finished initializing (type={})", (Object)this.m_name, (Object)this.m_resourceType);
    }

    public void initialize(ResourceType type) {
        LOG.debug("{} initializing", (Object)this.m_name);
        this.m_resourceType = type;
        LOG.debug("{} finished initializing", (Object)this.m_name);
    }

    public void fillRequest(SnmpCollectionRequest request) {
        this.assertInitialized();
        request.addResourceType(this.m_resourceType);
        request.addTable(this);
    }

    private void assertInitialized() {
        if (this.m_resourceType == null) {
            throw new IllegalStateException("Table " + this.getName() + " is not initialied!");
        }
    }

    public String toString() {
        return this.getName();
    }

    public CollectionTracker createCollectionTracker(final SnmpAgent agent, final SampleSet sampleSet) {
        ArrayList<SnmpObjId> snmpObjIds = new ArrayList<SnmpObjId>();
        for (IColumn iColumn : this.m_resourceType.getColumns()) {
            snmpObjIds.add(iColumn.getOid());
        }
        for (IColumn iColumn : this.m_columns) {
            snmpObjIds.add(iColumn.getOid());
        }
        SnmpObjId[] ids = snmpObjIds.toArray(new SnmpObjId[snmpObjIds.size()]);
        return new TableTracker(ids){

            public void rowCompleted(SnmpRowResult row) {
                Resource resource = Table.this.m_resourceType.getResource(agent, row);
                for (Column column : Table.this.m_columns) {
                    SnmpValue snmpValue;
                    Metric metric = column.createMetric(Table.this.getName());
                    if (metric == null) {
                        snmpValue = row.getValue(column.getOid());
                        if (snmpValue == null) continue;
                        String attrValue = column.getValue(snmpValue);
                        resource.setAttribute(column.getAlias(), attrValue);
                        continue;
                    }
                    snmpValue = row.getValue(column.getOid());
                    if (snmpValue == null) continue;
                    SampleValue sampleValue = metric.getType().getValue((Number)snmpValue.toBigInteger());
                    sampleSet.addMeasurement(resource, metric, sampleValue);
                }
            }
        };
    }

    public Set<Metric> getMetrics() {
        HashSet<Metric> metrics = new HashSet<Metric>();
        for (Column column : this.m_columns) {
            Metric metric = column.createMetric(this.getName());
            if (metric == null) continue;
            metrics.add(metric);
        }
        return metrics;
    }

    public Metric getMetric(String metricName) {
        for (Column column : this.m_columns) {
            if (!column.getAlias().equals(metricName)) continue;
            return column.createMetric(this.getName());
        }
        return null;
    }

    public static Table asTable(ITable table) {
        if (table == null) {
            return null;
        }
        if (table instanceof Table) {
            return (Table)table;
        }
        Table newTable = new Table();
        newTable.setName(table.getName());
        newTable.setInstance(table.getInstance());
        newTable.setColumns(table.getColumns());
        return newTable;
    }

    public static Table[] asTables(ITable[] tables) {
        if (tables == null) {
            return null;
        }
        Table[] newTables = new Table[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            newTables[i] = Table.asTable(tables[i]);
        }
        return newTables;
    }
}

