/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.opennms.netmgt.api.sample.CollectionConfiguration;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.MetricRepository;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionConfig;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionGroup;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionInitializationCache;
import org.opennms.netmgt.sampler.config.snmp.Parser;
import org.opennms.netmgt.sampler.config.snmp.SnmpAgent;
import org.opennms.netmgt.sampler.config.snmp.SnmpCollectionRequest;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpMetricRepository
implements MetricRepository,
CollectionConfiguration<SnmpAgent, SnmpCollectionRequest> {
    private static Logger LOG = LoggerFactory.getLogger(SnmpMetricRepository.class);
    private final URL m_dataCollectionConfigURL;
    private final URL[] m_dataCollectionGroupURLs;
    private String m_username = "admin";
    private String m_password = "admin";
    private DataCollectionConfig m_dataCollectionConfig;

    private static URL[] findEntries(Bundle bundle, String dir) {
        ArrayList urls = new ArrayList();
        Enumeration en = bundle.findEntries(dir, null, true);
        while (en.hasMoreElements()) {
            urls.add(en.nextElement());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public SnmpMetricRepository(String dataCollectionPath, String dataCollectionDir, Bundle bundle) throws Exception {
        this(bundle.getEntry(dataCollectionPath), SnmpMetricRepository.findEntries(bundle, dataCollectionDir));
    }

    public SnmpMetricRepository(URL dataCollectionConfigURL, URL ... dataCollectionGroupURLs) throws Exception {
        this.m_dataCollectionConfigURL = dataCollectionConfigURL;
        this.m_dataCollectionGroupURLs = dataCollectionGroupURLs;
        this.refresh();
    }

    public SnmpMetricRepository(URL dataCollectionConfigURL, String groupURLs) throws Exception {
        this.m_dataCollectionConfigURL = dataCollectionConfigURL;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (groupURLs != null && !"".equals(groupURLs)) {
            for (String url : groupURLs.split(",")) {
                try {
                    urls.add(new URL(url.trim()));
                }
                catch (MalformedURLException e) {
                    LOG.warn("Invalid URL specified in {} configuration: {}", (Object)this.getClass().getSimpleName(), (Object)url);
                }
            }
        }
        this.m_dataCollectionGroupURLs = urls.toArray(new URL[0]);
        this.refresh();
    }

    public final void refresh() throws JAXBException, IOException {
        LOG.debug("refresh() called");
        Parser parser = new Parser(this.m_username, this.m_password);
        DataCollectionInitializationCache cache = new DataCollectionInitializationCache();
        if (this.m_dataCollectionGroupURLs != null) {
            LOG.debug("parsing datacollection group URLs: {}", Arrays.asList(this.m_dataCollectionGroupURLs));
            for (URL dataCollectionGroupURL : this.m_dataCollectionGroupURLs) {
                DataCollectionGroup group = parser.getDataCollectionGroup(dataCollectionGroupURL);
                if (group == null) continue;
                cache.addDataCollectionGroup(group);
                group.gatherSymbols(cache);
            }
        }
        LOG.debug("pre-initializing {} groups", (Object)cache.getDataCollectionGroups().size());
        for (DataCollectionGroup group : cache.getDataCollectionGroups()) {
            group.initialize(cache);
        }
        LOG.debug("parsing datacollection config: {}", (Object)this.m_dataCollectionConfigURL);
        DataCollectionConfig config = parser.getDataCollectionConfig(this.m_dataCollectionConfigURL);
        if (config == null) {
            LOG.warn("Data collection config is null! ({})", (Object)this.m_dataCollectionConfigURL);
        } else {
            LOG.debug("initializing datacollection config");
            config.initialize(cache);
        }
        LOG.debug("finished initializing config");
        this.m_dataCollectionConfig = config;
    }

    public SnmpCollectionRequest createRequestForAgent(SnmpAgent agent) {
        SnmpCollectionRequest request = new SnmpCollectionRequest(agent);
        if (this.m_dataCollectionConfig == null) {
            LOG.warn("Unable to create request for agent {}, no data collection config!", (Object)agent);
        } else {
            this.m_dataCollectionConfig.fillRequest(request);
        }
        return request;
    }

    public Set<Metric> getMetrics(String groupName) {
        if (this.m_dataCollectionConfig == null) {
            LOG.warn("Unable to get metrics for group {}, no data collection config!", (Object)groupName);
            return null;
        }
        return this.m_dataCollectionConfig.getMetricsForGroup(groupName);
    }

    public Metric getMetric(String metricName) {
        if (this.m_dataCollectionConfig == null) {
            LOG.warn("Unable to get metric {}, no data collection config!", (Object)metricName);
            return null;
        }
        return this.m_dataCollectionConfig.getMetric(metricName);
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }
}

