/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.config.api.collection.IDataCollectionGroup;
import org.opennms.netmgt.config.api.collection.IGroupReference;
import org.opennms.netmgt.config.api.collection.ISnmpCollection;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionGroup;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionInitializationCache;
import org.opennms.netmgt.sampler.config.snmp.GroupReference;
import org.opennms.netmgt.sampler.config.snmp.Rrd;
import org.opennms.netmgt.sampler.config.snmp.SnmpCollectionRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="snmp-collection")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SnmpCollection
implements ISnmpCollection {
    private static final IGroupReference[] EMPTY_GROUP_REFERENCE_ARRAY = new IGroupReference[0];
    private static final IDataCollectionGroup[] EMPTY_DATA_COLLECTION_GROUP_ARRAY = new IDataCollectionGroup[0];
    private static final Logger LOG = LoggerFactory.getLogger(SnmpCollection.class);
    @XmlAttribute(name="name")
    private String m_name = "default";
    @XmlElement(name="include-collection")
    private List<GroupReference> m_includedGroups = new ArrayList<GroupReference>();
    @XmlElement(name="datacollection-group")
    private List<DataCollectionGroup> m_dataCollectionGroups = new ArrayList<DataCollectionGroup>();
    @XmlElement(name="rrd")
    private Rrd m_rrd;

    public String getName() {
        return this.m_name;
    }

    public IGroupReference[] getIncludedGroups() {
        return this.m_includedGroups.toArray(EMPTY_GROUP_REFERENCE_ARRAY);
    }

    public IDataCollectionGroup[] getDataCollectionGroups() {
        return this.m_dataCollectionGroups.toArray(EMPTY_DATA_COLLECTION_GROUP_ARRAY);
    }

    public void initialize(DataCollectionInitializationCache cache) {
        LOG.debug("{} initializing using cache: {}", (Object)cache);
        LinkedHashMap<String, DataCollectionGroup> groups = new LinkedHashMap<String, DataCollectionGroup>();
        for (DataCollectionGroup group : this.m_dataCollectionGroups) {
            groups.put(group.getName(), group);
        }
        if (this.m_includedGroups != null && this.m_includedGroups.size() > 0) {
            LOG.trace("{} initializing using {} included groups", (Object)this.m_name, (Object)this.m_includedGroups.size());
            for (GroupReference ref : this.m_includedGroups) {
                String groupName = ref.getDataCollectionGroup();
                if (groups.containsKey(groupName)) continue;
                DataCollectionGroup group = cache.getDataCollectionGroup(groupName);
                groups.put(groupName, group);
            }
        }
        this.m_dataCollectionGroups = new ArrayList(groups.values());
        LOG.debug("{} initializing all required resources, tables, and groups.", (Object)this.m_name);
        for (DataCollectionGroup group : this.m_dataCollectionGroups) {
            group.initialize(cache);
        }
        LOG.debug("{} finished initializing", (Object)this.m_name);
    }

    public void fillRequest(SnmpCollectionRequest request) {
        this.assertInitialized();
        for (DataCollectionGroup group : this.m_dataCollectionGroups) {
            group.fillRequest(request);
        }
    }

    private void assertInitialized() {
        if (this.m_dataCollectionGroups == null) {
            throw new IllegalStateException("snmp-collection " + this.getName() + " is not initialized!");
        }
    }

    public Set<Metric> getMetricsForGroup(String groupName) {
        for (DataCollectionGroup group : this.m_dataCollectionGroups) {
            Set<Metric> metrics = group.getMetricsForGroup(groupName);
            if (metrics == null) continue;
            return metrics;
        }
        return null;
    }

    public Metric getMetric(String metricName) {
        for (DataCollectionGroup group : this.m_dataCollectionGroups) {
            Metric metric = group.getMetric(metricName);
            if (metric == null) continue;
            return metric;
        }
        return null;
    }
}

