/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.api.sample.Agent;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.config.api.collection.IColumn;
import org.opennms.netmgt.config.api.collection.IExpression;
import org.opennms.netmgt.config.api.collection.IResourceType;
import org.opennms.netmgt.sampler.config.snmp.Column;
import org.opennms.netmgt.sampler.config.snmp.Expression;
import org.opennms.netmgt.sampler.config.snmp.PropertiesUtils;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="resourceType")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ResourceType
implements IResourceType {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceType.class);
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="label")
    private String m_label;
    @XmlElement(name="resourceName")
    private Expression m_resourceNameExpression;
    @XmlElement(name="resourceLabel")
    private Expression m_resourceLabelExpression;
    @XmlElement(name="resourceKind")
    private Expression m_resourceKindExpression;
    @XmlElement(name="column")
    private Column[] m_columns = new Column[0];

    public String getTypeName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public IExpression getResourceNameExpression() {
        return this.m_resourceNameExpression;
    }

    public void setResourceNameExpression(IExpression expression) {
        this.m_resourceNameExpression = Expression.asExpression(expression);
    }

    public Expression getResourceLabelExpression() {
        return this.m_resourceLabelExpression;
    }

    public void setResourceLabelExpression(IExpression expression) {
        this.m_resourceLabelExpression = Expression.asExpression(expression);
    }

    public Expression getResourceKindExpression() {
        return this.m_resourceKindExpression;
    }

    public void setResourceKindExpression(IExpression expression) {
        this.m_resourceKindExpression = Expression.asExpression(expression);
    }

    public IColumn[] getColumns() {
        return this.m_columns;
    }

    public void setColumns(IColumn[] columns) {
        this.m_columns = Column.asColumns(columns);
    }

    public String toString() {
        return this.getTypeName();
    }

    public Resource getResource(Agent agent, SnmpRowResult row) {
        String resourceName = this.createResourceName(row);
        String resourceLabel = this.createResourceLabel(row);
        Resource resource = new Resource(agent, this.getTypeName(), resourceName, resourceLabel);
        for (Column column : this.m_columns) {
            SnmpValue val = row.getValue(column.getOid());
            if (val == null) continue;
            String attrValue = column.getValue(val);
            resource.setAttribute(column.getAlias(), attrValue);
        }
        return resource;
    }

    private String createResourceName(SnmpRowResult row) {
        String template = this.getResourceNameExpression().getTemplate();
        if (template == null) {
            return this.m_name;
        }
        return this.evaluateExpressionTemplate(template, row);
    }

    private String createResourceLabel(SnmpRowResult row) {
        String template = this.getResourceLabelExpression().getTemplate();
        if (template == null) {
            return null;
        }
        return this.evaluateExpressionTemplate(template, row);
    }

    private String evaluateExpressionTemplate(String template, final SnmpRowResult row) {
        PropertiesUtils.SymbolTable symbolTable = new PropertiesUtils.SymbolTable(){

            @Override
            public String getSymbolValue(String symbol) {
                if ("index".equalsIgnoreCase(symbol)) {
                    return row.getInstance().toString();
                }
                for (Column column : ResourceType.this.m_columns) {
                    if (!column.getAlias().equals(symbol)) continue;
                    SnmpObjId base = column.getOid();
                    SnmpValue value = row.getValue(base);
                    if (value == null) {
                        LOG.warn("Value of column alias {} was not found in SNMP row: {}", (Object)column.getAlias(), (Object)row);
                        return null;
                    }
                    return column.getValue(value);
                }
                return null;
            }
        };
        return PropertiesUtils.substitute(template, symbolTable);
    }

    public static ResourceType asResourceType(IResourceType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof ResourceType) {
            return (ResourceType)type;
        }
        ResourceType newType = new ResourceType();
        newType.setName(type.getTypeName());
        newType.setLabel(type.getLabel());
        newType.setResourceNameExpression(type.getResourceNameExpression());
        newType.setResourceLabelExpression(type.getResourceLabelExpression());
        newType.setResourceKindExpression(type.getResourceKindExpression());
        newType.setColumns(type.getColumns());
        return newType;
    }

    public static ResourceType[] asResourceTypes(IResourceType[] resourceTypes) {
        if (resourceTypes == null) {
            return null;
        }
        ResourceType[] newResourceTypes = new ResourceType[resourceTypes.length];
        for (int i = 0; i < resourceTypes.length; ++i) {
            newResourceTypes[i] = ResourceType.asResourceType(resourceTypes[i]);
        }
        return newResourceTypes;
    }
}

