/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.api.sample.Agent;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.api.sample.SampleSet;
import org.opennms.netmgt.config.api.collection.IGroup;
import org.opennms.netmgt.config.api.collection.IMibObject;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionInitializationCache;
import org.opennms.netmgt.sampler.config.snmp.MibObject;
import org.opennms.netmgt.sampler.config.snmp.SnmpAgent;
import org.opennms.netmgt.sampler.config.snmp.SnmpCollectionRequest;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="group")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Group
implements IGroup {
    private static final MibObject[] EMPTY_MIB_OBJECT_ARRAY = new MibObject[0];
    private static Logger LOG = LoggerFactory.getLogger(Group.class);
    @XmlAttribute(name="name")
    private String m_name;
    @XmlElement(name="mibObj")
    private List<MibObject> m_mibObjects = new ArrayList<MibObject>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public IMibObject[] getMibObjects() {
        return this.m_mibObjects.toArray(EMPTY_MIB_OBJECT_ARRAY);
    }

    public void setMibObjects(IMibObject[] mibObjects) {
        this.m_mibObjects = Arrays.asList(MibObject.asMibObjects(mibObjects));
    }

    public void initialize(DataCollectionInitializationCache cache) {
        this.initialize();
    }

    public void initialize() {
        LOG.debug("{} initializing", (Object)this.m_name);
        for (MibObject mibObj : this.m_mibObjects) {
            mibObj.initialize(this);
        }
        LOG.debug("{} finished initializing", (Object)this.m_name);
    }

    public void fillRequest(SnmpCollectionRequest request) {
        request.addGroup(this);
    }

    public String toString() {
        return this.getName();
    }

    public Set<Metric> getMetrics() {
        HashSet<Metric> metrics = new HashSet<Metric>();
        for (MibObject mibObj : this.m_mibObjects) {
            Metric metric = mibObj.createMetric();
            if (metric == null) continue;
            metrics.add(metric);
        }
        return metrics;
    }

    public Metric getMetric(String metricName) {
        for (MibObject mibObj : this.m_mibObjects) {
            if (!mibObj.getAlias().equals(metricName)) continue;
            return mibObj.createMetric();
        }
        return null;
    }

    public CollectionTracker createCollectionTracker(SnmpAgent agent, SampleSet sampleSet) {
        Resource groupResource = new Resource((Agent)agent, "node", this.m_name, null);
        ArrayList<CollectionTracker> trackers = new ArrayList<CollectionTracker>();
        for (MibObject mibObj : this.m_mibObjects) {
            trackers.add(mibObj.createCollectionTracker(groupResource, sampleSet));
        }
        return new AggregateTracker(trackers);
    }

    public static Group asGroup(IGroup group) {
        if (group == null) {
            return null;
        }
        if (group instanceof Group) {
            return (Group)group;
        }
        Group newGroup = new Group();
        newGroup.setName(group.getName());
        newGroup.setMibObjects(group.getMibObjects());
        return newGroup;
    }

    public static Group[] asGroups(IGroup[] groups) {
        if (groups == null) {
            return null;
        }
        Group[] newGroups = new Group[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            newGroups[i] = Group.asGroup(groups[i]);
        }
        return newGroups;
    }
}

