/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample.support;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.api.sample.GaugeValue;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.NanValue;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.api.sample.Results;
import org.opennms.netmgt.api.sample.Sample;
import org.opennms.netmgt.api.sample.SampleProcessorBuilder;
import org.opennms.netmgt.api.sample.SampleRepository;
import org.opennms.netmgt.api.sample.SampleSet;
import org.opennms.netmgt.api.sample.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileRepository
implements SampleRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleFileRepository.class);
    private static final String SEPARATOR = "$";
    private final File m_attributesFile;
    private final File m_sampleFile;

    public SimpleFileRepository(File attributesFile, File sampleFile) {
        this.m_attributesFile = attributesFile;
        this.m_sampleFile = sampleFile;
    }

    @Override
    public void save(SampleSet samples) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(this.m_sampleFile, true)));
            for (Sample m : samples.getSamples()) {
                LOG.debug(String.format("Saving Measurement: %s for %s at %s = %.1f", m.getMetric().getName(), m.getResource().getIdentifier(), m.getTimestamp().asDate(), m.getValue().doubleValue()));
                out.printf("%s %s %d %s%n", m.getResource().getIdentifier(), m.getMetric().getName(), m.getTimestamp().convert(TimeUnit.SECONDS), m.getValue());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable e) {}
        }
        Properties attributes = this.loadAttributes();
        for (Resource r : samples.getResources()) {
            for (Map.Entry<String, String> attribute : r.getAttributes().entrySet()) {
                attributes.setProperty(SimpleFileRepository.prefix(r) + attribute.getKey(), attribute.getValue());
            }
        }
        this.storeAttributes(attributes);
    }

    private static String prefix(Resource r) {
        return r.getIdentifier() + SEPARATOR;
    }

    private Properties loadAttributes() {
        Properties attributes = new Properties();
        if (!this.m_attributesFile.canRead()) {
            return attributes;
        }
        FileReader r = null;
        try {
            r = new FileReader(this.m_attributesFile);
            attributes.load(r);
            Properties properties = attributes;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (r != null) {
                    ((Reader)r).close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void storeAttributes(Properties attributes) {
        FileWriter w = null;
        try {
            w = new FileWriter(this.m_attributesFile);
            attributes.store(w, "Save attributes");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (w != null) {
                    ((Writer)w).close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public Results find(SampleProcessorBuilder builder, Timestamp start, Timestamp end, Resource resource, Metric ... metrics) {
        if (resource == null) {
            throw new IllegalArgumentException("null resource argument");
        }
        if (builder != null) {
            throw new IllegalArgumentException("builder functionality still needs to be implemented here!");
        }
        this.loadAttributesForResource(resource);
        long startSeconds = start == null ? 0L : start.asSeconds();
        long endSeconds = end == null ? Long.MAX_VALUE : end.asSeconds();
        try (Scanner scanner = null;){
            scanner = new Scanner(this.m_sampleFile);
            Results results = new Results(resource, metrics);
            while (scanner.hasNext()) {
                String resourceName = scanner.next();
                String metricName = scanner.next();
                long timeInSeconds = scanner.nextLong();
                GaugeValue value = new GaugeValue(scanner.nextDouble());
                if (!resourceName.equals(resource.getIdentifier()) || startSeconds > timeInSeconds || timeInSeconds >= endSeconds) continue;
                for (Metric metric : metrics) {
                    if (!metricName.equals(metric.getName())) continue;
                    Timestamp t = new Timestamp(timeInSeconds, TimeUnit.SECONDS);
                    Sample m = new Sample(resource, metric, t, value);
                    results.addSample(m);
                }
            }
            for (Results.Row row : results.getRows()) {
                for (Metric metric : metrics) {
                    if (row.containsSample(metric)) continue;
                    row.addSample(new Sample(resource, metric, row.getTimestamp(), new NanValue()));
                }
            }
            Results results2 = results;
            return results2;
        }
    }

    private void loadAttributesForResource(Resource resource) {
        String resourcePrefix = SimpleFileRepository.prefix(resource);
        Properties attributes = this.loadAttributes();
        for (String key : attributes.stringPropertyNames()) {
            if (!key.startsWith(resourcePrefix)) continue;
            String attrName = key.substring(resourcePrefix.length());
            String attrValue = attributes.getProperty(key);
            resource.setAttribute(attrName, attrValue);
        }
    }
}

