/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample.math;

import org.opennms.netmgt.api.sample.NanValue;
import org.opennms.netmgt.api.sample.Results;
import org.opennms.netmgt.api.sample.Sample;
import org.opennms.netmgt.api.sample.SampleProcessor;
import org.opennms.netmgt.api.sample.SampleValue;
import org.opennms.netmgt.api.sample.Timestamp;

public class Rate
extends SampleProcessor {
    private Results.Row m_prev;

    @Override
    public boolean hasNext() {
        return this.getProducer().hasNext();
    }

    @Override
    public Results.Row next() {
        Results.Row r = (Results.Row)this.getProducer().next();
        Results.Row newRow = new Results.Row(r.getResource(), r.getTimestamp());
        for (Sample s : r) {
            Timestamp prevTime = this.m_prev == null ? null : this.m_prev.getTimestamp();
            SampleValue<?> prevVal = this.m_prev == null ? null : this.m_prev.getSample(s.getMetric()).getValue();
            long elapsed = this.m_prev == null ? 0L : s.getTimestamp().asMillis() - prevTime.asMillis();
            NanValue rate = this.m_prev == null ? new NanValue() : s.getValue().delta(prevVal).multiply(1000.0).divide(elapsed);
            Sample newSample = new Sample(s.getResource(), s.getMetric(), s.getTimestamp(), rate);
            newRow.addSample(newSample);
        }
        this.m_prev = r;
        return this.fillMissingSamples(newRow);
    }

    public String toString() {
        return String.format("%s | %s()", this.getProducer().toString(), this.getClass().getSimpleName());
    }
}

