/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample.math;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.NanValue;
import org.opennms.netmgt.api.sample.Results;
import org.opennms.netmgt.api.sample.Sample;
import org.opennms.netmgt.api.sample.SampleProcessor;
import org.opennms.netmgt.api.sample.SampleValue;
import org.opennms.netmgt.api.sample.Timestamp;

public class Lerp
extends SampleProcessor {
    public static final TimeUnit STD_UNITS = TimeUnit.MILLISECONDS;
    private final Iterator<Timestamp> m_stepsIter;
    private final Timestamp m_start;
    private final Timestamp m_finish;
    private final long m_heartBeat;
    private final long m_step;
    private final TimeUnit m_stepUnits;
    private Results.Row m_rowL = null;
    private Results.Row m_rowR = null;
    private Results.Row m_prevL = null;
    private Timestamp m_currentStep = null;
    private boolean m_initComplete = false;

    public Lerp(Timestamp start, Timestamp finish, long heartBeat, long step) {
        this(start, finish, heartBeat, step, STD_UNITS);
    }

    public Lerp(Timestamp start, Timestamp finish, long heartBeat, long step, TimeUnit stepUnits) {
        this.m_start = start;
        this.m_finish = finish;
        this.m_heartBeat = heartBeat;
        this.m_step = step;
        this.m_stepUnits = stepUnits;
        this.m_stepsIter = new Steps(this.m_start, this.m_finish, this.m_step, this.m_stepUnits).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.m_stepsIter.hasNext() || this.m_currentStep != null;
    }

    @Override
    public Results.Row next() {
        if (!this.m_initComplete) {
            this.m_prevL = this.m_rowL = this.nextRow();
            this.m_rowR = this.nextRow();
            this.m_currentStep = this.m_stepsIter.next();
            this.m_initComplete = true;
        }
        if (this.m_rowR == null) {
            Results.Row r = new Results.Row(this.m_rowL.getResource(), this.m_currentStep);
            if (this.m_prevL.getTimestamp().lessThan(this.m_currentStep)) {
                this.storeInterpolatedSamples(r, this.m_prevL, this.m_rowL, this.m_currentStep, this.getMetrics());
            }
            this.stepAdvance();
            return this.fillMissingSamples(r);
        }
        Timestamp xL = this.m_rowL.getTimestamp();
        Timestamp xR = this.m_rowR.getTimestamp();
        if (xL.greaterThan(this.m_currentStep)) {
            Results.Row r = new Results.Row(this.m_rowL.getResource(), this.m_currentStep);
            if (xL.equals(this.m_prevL.getTimestamp())) {
                this.storeInterpolatedSamples(r, this.m_rowL, this.m_rowR, this.m_currentStep, this.getMetrics());
                this.stepAdvance();
            } else {
                this.storeInterpolatedSamples(r, this.m_prevL, this.m_rowL, this.m_currentStep, this.getMetrics());
                this.stepAdvance();
            }
            return this.fillMissingSamples(r);
        }
        if ((xL.lessThan(this.m_currentStep) || xL.equals(this.m_currentStep)) && (xR.greaterThan(this.m_currentStep) || xR.equals(this.m_currentStep))) {
            Results.Row r = new Results.Row(this.m_rowL.getResource(), this.m_currentStep);
            this.storeInterpolatedSamples(r, this.m_rowL, this.m_rowR, this.m_currentStep, this.getMetrics());
            this.advance(true);
            return this.fillMissingSamples(r);
        }
        this.advance(false);
        return this.next();
    }

    private void storeInterpolatedSamples(Results.Row out, Results.Row rowL, Results.Row rowR, Timestamp step, Collection<Metric> metrics) {
        for (Metric m : metrics) {
            Sample yL = rowL.getSample(m);
            Sample yR = rowR.getSample(m);
            SampleValue value = null;
            value = yL != null && yR != null ? this.interpolate(step, rowL.getTimestamp(), rowR.getTimestamp(), yL, yR) : new NanValue();
            out.addSample(new Sample(out.getResource(), m, step, value));
        }
    }

    private SampleValue<?> interpolate(Timestamp ts, Timestamp ts0, Timestamp ts1, Sample s0, Sample s1) {
        if (ts1.minus(ts0).greaterThan(new Timestamp(this.m_heartBeat, this.m_stepUnits))) {
            return null;
        }
        SampleValue<?> y0 = s0.getValue();
        SampleValue<?> y1 = s1.getValue();
        long x = ts.asMillis();
        long x0 = ts0.asMillis();
        long x1 = ts1.asMillis();
        return y1.subtract(y0).multiply(x - x0).divide(x1 - x0).add(y0);
    }

    private void advance(boolean withStep) {
        if (withStep) {
            this.stepAdvance();
        }
        this.m_prevL = this.m_rowL;
        this.m_rowL = this.m_rowR;
        this.m_rowR = this.nextRow();
    }

    private void stepAdvance() {
        this.m_currentStep = this.m_stepsIter.hasNext() ? this.m_stepsIter.next() : null;
    }

    private Results.Row nextRow() {
        if (this.getProducer().hasNext()) {
            return (Results.Row)this.getProducer().next();
        }
        return null;
    }

    public String toString() {
        return String.format("%s(start=%s, finish=%s, step=%d, step_units=%s)", new Object[]{this.getClass().getSimpleName(), this.m_start, this.m_finish, this.m_step, this.m_stepUnits});
    }

    private static final class Steps
    implements Iterable<Timestamp> {
        private final Timestamp m_start;
        private final Timestamp m_finish;
        private final long m_step;
        private final TimeUnit m_stepUnits;
        private int m_count = 0;

        private Steps(Timestamp start, Timestamp finish, long step, TimeUnit stepUnits) {
            this.m_start = start.atStepBoundaryStart(step, stepUnits);
            this.m_finish = finish.atStepBoundaryEnd(step, stepUnits);
            this.m_step = step;
            this.m_stepUnits = stepUnits;
        }

        @Override
        public Iterator<Timestamp> iterator() {
            return new Iterator<Timestamp>(){

                private Timestamp getCurrent() {
                    return Steps.this.m_start.plus((long)Steps.this.m_count * Steps.this.m_step, Steps.this.m_stepUnits);
                }

                @Override
                public boolean hasNext() {
                    return this.getCurrent().compareTo(Steps.this.m_finish) < 0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Timestamp next() {
                    try {
                        Timestamp timestamp = this.getCurrent();
                        return timestamp;
                    }
                    finally {
                        Steps.this.m_count++;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

