/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.opennms.netmgt.api.sample.CounterValue;
import org.opennms.netmgt.api.sample.GaugeValue;
import org.opennms.netmgt.api.sample.MetricType;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="sample-value")
public abstract class SampleValue<T extends Number>
extends Number
implements Comparable<Number> {
    private static final long serialVersionUID = 2L;
    public static final byte COUNTER = 1;
    public static final byte DERIVE = 2;
    public static final byte ABSOLUTE = 3;
    public static final byte GAUGE = 4;
    private final T m_value;

    public SampleValue() {
        this.m_value = null;
    }

    public SampleValue(T value) {
        this.m_value = value;
    }

    protected T getValue() {
        return this.m_value;
    }

    public abstract BigInteger bigIntegerValue();

    public static SampleValue<?> compose(ByteBuffer data) {
        byte dataType = data.get();
        switch (dataType) {
            case 1: {
                byte[] value = new byte[data.remaining()];
                data.get(value, 0, data.remaining());
                return new CounterValue(new BigInteger(value));
            }
            case 4: {
                return new GaugeValue(data.getDouble());
            }
            case 2: 
            case 3: {
                throw new UnsupportedOperationException("NOT IMPLEMENTED: FIXME!");
            }
        }
        throw new IllegalArgumentException(String.format("parsed unknown type descriptor from buffer (0x%x)", dataType));
    }

    public static ByteBuffer decompose(SampleValue<?> value) {
        switch (value.getType()) {
            case COUNTER: {
                byte[] bytes = ((BigInteger)value.getValue()).toByteArray();
                ByteBuffer res = ByteBuffer.allocate(bytes.length + 1).put((byte)1).put(bytes);
                res.rewind();
                return res;
            }
            case GAUGE: {
                ByteBuffer res = ByteBuffer.allocate(9).put((byte)4).putDouble((Double)value.getValue());
                res.rewind();
                return res;
            }
            case DERIVE: {
                return ByteBuffer.allocate(9).put((byte)2).putLong((Long)value.getValue());
            }
            case ABSOLUTE: {
                return ByteBuffer.allocate(9).put((byte)3).putLong((Long)value.getValue());
            }
        }
        throw new IllegalArgumentException(String.format("value does not correspond to a known type", new Object[0]));
    }

    public static String toHex(SampleValue<?> value) {
        return Hex.encodeHexString((byte[])SampleValue.decompose(value).array());
    }

    public static SampleValue<?> fromHex(String value) {
        try {
            return SampleValue.compose(ByteBuffer.wrap(Hex.decodeHex((char[])value.toCharArray())));
        }
        catch (DecoderException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue().toString();
    }

    public boolean isNaN() {
        return this.getValue() == null || this.getValue().equals(Double.NaN);
    }

    public boolean lessThan(Number other) {
        return this.compareTo(other) < 0;
    }

    public boolean greaterThan(Number other) {
        return this.compareTo(other) > 0;
    }

    public abstract SampleValue<?> delta(Number var1);

    public abstract SampleValue<?> subtract(Number var1);

    public abstract SampleValue<?> add(Number var1);

    public abstract SampleValue<?> multiply(Number var1);

    public abstract SampleValue<?> divide(Number var1);

    public abstract MetricType getType();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_value == null ? 0 : this.m_value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampleValue)) {
            return false;
        }
        SampleValue other = (SampleValue)obj;
        return !(this.m_value == null ? other.m_value != null : !this.m_value.equals(other.m_value));
    }
}

