/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.api.sample.Agent;

@XmlRootElement(name="resource")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Resource
implements Comparable<Resource>,
Serializable {
    private static final long serialVersionUID = 3L;
    @XmlElement(name="agent")
    private final Agent m_agent;
    @XmlAttribute(name="name")
    private final String m_name;
    @XmlAttribute(name="label")
    private final String m_label;
    @XmlAttribute(name="type")
    private final String m_type;
    @XmlElementWrapper(name="attributes")
    @XmlElement(name="attribute")
    private final Map<String, String> m_attributes = new HashMap<String, String>();

    public Resource() {
        this.m_agent = null;
        this.m_name = null;
        this.m_label = null;
        this.m_type = null;
    }

    public Resource(Agent agent, String type, String name, String label) {
        this.m_agent = agent;
        this.m_name = name;
        this.m_label = label;
        this.m_type = type;
    }

    public String getIdentifier() {
        return String.format("%s|%s|%s", this.m_agent.getId(), this.m_type, this.m_name);
    }

    public String getType() {
        return this.m_type;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLabel() {
        return this.m_label;
    }

    public Agent getAgent() {
        return this.m_agent;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Resource)) {
            return false;
        }
        return this.getIdentifier().equals(((Resource)other).getIdentifier());
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    @Override
    public int compareTo(Resource other) {
        return this.getIdentifier().compareTo(other.getIdentifier());
    }

    public void setAttribute(String attrName, String attrValue) {
        this.m_attributes.put(attrName, attrValue);
    }

    public String getAttribute(String attrName) {
        return this.m_attributes.get(attrName);
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public String toString() {
        return this.getIdentifier();
    }
}

