/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.math.BigInteger;
import org.opennms.netmgt.api.sample.MetricType;
import org.opennms.netmgt.api.sample.SampleValue;

public class GaugeValue
extends SampleValue<Double> {
    private static final long serialVersionUID = 2L;

    public GaugeValue() {
        super(null);
    }

    public GaugeValue(Integer value) {
        this((double)value);
    }

    public GaugeValue(Long value) {
        this((double)value);
    }

    public GaugeValue(Double value) {
        super(value);
    }

    public GaugeValue delta(Number other) {
        return this.subtract(other);
    }

    public GaugeValue add(Number other) {
        return new GaugeValue((Double)this.getValue() + this.getDouble(other));
    }

    public GaugeValue subtract(Number other) {
        return new GaugeValue((Double)this.getValue() - this.getDouble(other));
    }

    public GaugeValue multiply(Number other) {
        return new GaugeValue((Double)this.getValue() * this.getDouble(other));
    }

    public GaugeValue divide(Number object) {
        return new GaugeValue((Double)this.getValue() / this.getDouble(object));
    }

    @Override
    public int intValue() {
        return ((Double)this.getValue()).intValue();
    }

    @Override
    public long longValue() {
        return ((Double)this.getValue()).longValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public float floatValue() {
        return ((Double)this.getValue()).floatValue();
    }

    @Override
    public double doubleValue() {
        return (Double)this.getValue();
    }

    @Override
    public MetricType getType() {
        return MetricType.GAUGE;
    }

    @Override
    public int compareTo(Number o) {
        return ((Double)this.getValue()).compareTo(this.getDouble(o));
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof GaugeValue) {
            return ((Double)this.getValue()).equals(((GaugeValue)o).getValue());
        }
        if (o instanceof Double) {
            return ((Double)this.getValue()).equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Double)this.getValue()).hashCode();
    }

    private Double getDouble(Number num) {
        if (num instanceof GaugeValue) {
            return (Double)((GaugeValue)num).getValue();
        }
        return num.doubleValue();
    }
}

