/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceInfo;
import org.linkedin.util.io.resource.internal.AbstractResource;
import org.linkedin.util.io.resource.internal.InternalResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;
import org.linkedin.util.io.resource.internal.ResourceProviderChain;

public class ResourceChain
extends AbstractResource {
    private final Resource _resource;

    public ResourceChain(InternalResourceProvider resourceProvider, String path, Resource resource) {
        super(resourceProvider, path);
        this._resource = resource;
    }

    @Override
    public boolean exists() {
        return this._resource.exists();
    }

    @Override
    public File getFile() throws IOException {
        return this._resource.getFile();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this._resource.getInputStream();
    }

    @Override
    public ResourceInfo getInfo() throws IOException {
        return this._resource.getInfo();
    }

    @Override
    public boolean isDirectory() {
        return this._resource.isDirectory();
    }

    @Override
    public URI toURI() {
        return this._resource.toURI();
    }

    @Override
    public boolean isModifiedSince(long time) {
        return this._resource.isModifiedSince(time);
    }

    public static Resource create(Resource ... resources) {
        return ResourceChain.create(Arrays.asList(resources));
    }

    public static Resource create(List<Resource> resources) {
        if (resources.size() == 1) {
            return resources.get(0).chroot(".");
        }
        ArrayList<InternalResourceProvider> providers = new ArrayList<InternalResourceProvider>(resources.size());
        for (Resource resource : resources) {
            InternalResourceProvider provider = (InternalResourceProvider)((InternalResource)(resource = resource.chroot("."))).getResourceProvider();
            if (provider instanceof ResourceProviderChain) {
                ResourceProviderChain resourceProviderChain = (ResourceProviderChain)provider;
                providers.addAll(resourceProviderChain.getResourceProviders());
                continue;
            }
            providers.add(provider);
        }
        return new ResourceProviderChain(providers).getRootResource();
    }
}

