/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;

public class MultiOutputRrdStrategy
implements RrdStrategy<List<Object>, List<Object>> {
    private final List<RrdStrategy<Object, Object>> m_strategies = new ArrayList<RrdStrategy<Object, Object>>();
    private int m_graphStrategyIndex;
    private int m_fetchStrategyIndex;

    @Override
    public void setConfigurationProperties(Properties configurationParameters) {
    }

    public List<RrdStrategy<Object, Object>> getDelegates() {
        return this.m_strategies;
    }

    public void setDelegates(List<RrdStrategy<Object, Object>> delegates) {
        if (this.m_strategies == delegates) {
            return;
        }
        this.m_strategies.clear();
        this.m_strategies.addAll(delegates);
    }

    public int getGraphStrategyIndex() {
        return this.m_graphStrategyIndex;
    }

    public void setGraphStrategyIndex(int graphStrategyIndex) {
        this.m_graphStrategyIndex = graphStrategyIndex;
    }

    public int getFetchStrategyIndex() {
        return this.m_fetchStrategyIndex;
    }

    public void setFetchStrategyIndex(int fetchStrategyIndex) {
        this.m_fetchStrategyIndex = fetchStrategyIndex;
    }

    @Override
    public void closeFile(List<Object> rrd) throws Exception {
        for (int i = 0; i < rrd.size(); ++i) {
            this.m_strategies.get(i).closeFile(rrd.get(i));
        }
    }

    @Override
    public List<Object> createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        ArrayList<Object> retval = new ArrayList<Object>();
        for (RrdStrategy<Object, Object> strategy : this.m_strategies) {
            retval.add(strategy.createDefinition(creator, directory, rrdName, step, dataSources, rraList));
        }
        return retval;
    }

    @Override
    public void createFile(List<Object> rrdDef, Map<String, String> attributeMappings) throws Exception {
        for (int i = 0; i < rrdDef.size(); ++i) {
            this.m_strategies.get(i).createFile(rrdDef.get(i), attributeMappings);
        }
    }

    @Override
    public InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        return this.m_strategies.get(this.m_graphStrategyIndex).createGraph(command, workDir);
    }

    @Override
    public RrdGraphDetails createGraphReturnDetails(String command, File workDir) throws IOException, RrdException {
        return this.m_strategies.get(this.m_graphStrategyIndex).createGraphReturnDetails(command, workDir);
    }

    @Override
    public Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException, RrdException {
        return this.m_strategies.get(this.m_fetchStrategyIndex).fetchLastValue(rrdFile, ds, interval);
    }

    @Override
    public Double fetchLastValue(String rrdFile, String ds, String consolidationFunction, int interval) throws NumberFormatException, RrdException {
        return this.m_strategies.get(this.m_fetchStrategyIndex).fetchLastValue(rrdFile, ds, consolidationFunction, interval);
    }

    @Override
    public Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException, RrdException {
        return this.m_strategies.get(this.m_fetchStrategyIndex).fetchLastValueInRange(rrdFile, ds, interval, range);
    }

    @Override
    public String getDefaultFileExtension() {
        return this.m_strategies.get(this.m_fetchStrategyIndex).getDefaultFileExtension();
    }

    @Override
    public int getGraphLeftOffset() {
        return this.m_strategies.get(this.m_graphStrategyIndex).getGraphLeftOffset();
    }

    @Override
    public int getGraphRightOffset() {
        return this.m_strategies.get(this.m_graphStrategyIndex).getGraphRightOffset();
    }

    @Override
    public int getGraphTopOffsetWithText() {
        return this.m_strategies.get(this.m_graphStrategyIndex).getGraphTopOffsetWithText();
    }

    @Override
    public String getStats() {
        StringBuffer retval = new StringBuffer();
        for (RrdStrategy<Object, Object> strategy : this.m_strategies) {
            retval.append(strategy.getStats());
            retval.append("\n");
        }
        return retval.toString().trim();
    }

    @Override
    public List<Object> openFile(String fileName) throws Exception {
        ArrayList<Object> retval = new ArrayList<Object>();
        for (RrdStrategy<Object, Object> strategy : this.m_strategies) {
            retval.add(strategy.openFile(fileName));
        }
        return retval;
    }

    @Override
    public void promoteEnqueuedFiles(Collection<String> rrdFiles) {
        for (RrdStrategy<Object, Object> strategy : this.m_strategies) {
            strategy.promoteEnqueuedFiles(rrdFiles);
        }
    }

    @Override
    public void updateFile(List<Object> rrd, String owner, String data) throws Exception {
        for (int i = 0; i < rrd.size(); ++i) {
            this.m_strategies.get(i).updateFile(rrd.get(i), owner, data);
        }
    }
}

