/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmptyKeyRelaxedTrustSSLContext
extends SSLContextSpi {
    private static final Logger LOG = LoggerFactory.getLogger(EmptyKeyRelaxedTrustSSLContext.class);
    public static final String ALGORITHM = "EmptyKeyRelaxedTrust";
    private final SSLContext m_delegate;

    public EmptyKeyRelaxedTrustSSLContext() {
        SSLContext customContext = null;
        try {
            KeyManager[] keyManager = null;
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            customContext = SSLContext.getInstance("SSL");
            customContext.init(keyManager, trustManagers, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Could not find SSL algorithm in JVM", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOG.error("Could not find SSL algorithm in JVM", (Throwable)e);
        }
        this.m_delegate = customContext;
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        return this.m_delegate.createSSLEngine();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String arg0, int arg1) {
        return this.m_delegate.createSSLEngine(arg0, arg1);
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.m_delegate.getClientSessionContext();
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.m_delegate.getServerSessionContext();
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return this.m_delegate.getServerSocketFactory();
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return this.m_delegate.getSocketFactory();
    }

    @Override
    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom arg2) throws KeyManagementException {
    }
}

