/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;

public class CircuitBreakerLoadBalancer
extends LoadBalancerSupport
implements Traceable,
CamelContextAware {
    private final List<Class<?>> exceptions;
    private CamelContext camelContext;
    private int threshold;
    private long halfOpenAfter;
    private long lastFailure;
    private AtomicInteger failures = new AtomicInteger();

    public CircuitBreakerLoadBalancer(List<Class<?>> exceptions) {
        this.exceptions = exceptions;
    }

    public CircuitBreakerLoadBalancer() {
        this.exceptions = null;
    }

    public void setHalfOpenAfter(long halfOpenAfter) {
        this.halfOpenAfter = halfOpenAfter;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<Class<?>> getExceptions() {
        return this.exceptions;
    }

    protected boolean hasFailed(Exchange exchange) {
        boolean answer = false;
        if (exchange.getException() != null) {
            if (this.exceptions == null || this.exceptions.isEmpty()) {
                answer = true;
            } else {
                for (Class<?> exception : this.exceptions) {
                    if (exchange.getException(exception) == null) continue;
                    answer = true;
                    break;
                }
            }
        }
        return answer;
    }

    @Override
    public boolean isRunAllowed() {
        boolean forceShutdown = this.camelContext.getShutdownStrategy().forceShutdown(this);
        if (forceShutdown) {
            this.log.trace("Run not allowed as ShutdownStrategy is forcing shutting down");
        }
        return !forceShutdown && super.isRunAllowed();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            this.log.trace("Run not allowed, will reject executing exchange: {}", (Object)exchange);
            if (exchange.getException() == null) {
                exchange.setException(new RejectedExecutionException("Run is not allowed"));
            }
            callback.done(true);
            return true;
        }
        if (this.failures.get() >= this.threshold && System.currentTimeMillis() - this.lastFailure < this.halfOpenAfter) {
            exchange.setException(new RejectedExecutionException("CircuitBreaker Open: failures: " + this.failures + ", lastFailure: " + this.lastFailure));
            this.failures.set(0);
            callback.done(true);
            return true;
        }
        Processor processor = this.getProcessors().get(0);
        if (processor == null) {
            throw new IllegalStateException("No processors could be chosen to process CircuitBreaker");
        }
        AsyncProcessor albp = AsyncProcessorConverterHelper.convert(processor);
        boolean sync = albp.process(exchange, new CircuitBreakerCallback(exchange, callback));
        if (sync) {
            boolean failed = this.hasFailed(exchange);
            if (!failed) {
                this.failures.set(0);
            } else {
                this.failures.incrementAndGet();
                this.lastFailure = System.currentTimeMillis();
            }
        } else {
            this.log.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
            return false;
        }
        this.log.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
        callback.done(true);
        return true;
    }

    public String toString() {
        return "CircuitBreakerLoadBalancer[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "circuitbreaker";
    }

    class CircuitBreakerCallback
    implements AsyncCallback {
        private final AsyncCallback callback;
        private final Exchange exchange;

        CircuitBreakerCallback(Exchange exchange, AsyncCallback callback) {
            this.callback = callback;
            this.exchange = exchange;
        }

        @Override
        public void done(boolean doneSync) {
            if (!doneSync) {
                boolean failed = CircuitBreakerLoadBalancer.this.hasFailed(this.exchange);
                if (!failed) {
                    CircuitBreakerLoadBalancer.this.failures.set(0);
                } else {
                    CircuitBreakerLoadBalancer.this.failures.incrementAndGet();
                    CircuitBreakerLoadBalancer.this.lastFailure = System.currentTimeMillis();
                }
            }
            this.callback.done(doneSync);
        }
    }
}

