/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.PropertiesCache;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class RrdUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RrdUtils.class);
    private static PropertiesCache s_cache = new PropertiesCache();
    private static RrdStrategy<?, ?> m_rrdStrategy = null;
    private static final BeanFactory m_context;

    public static void createMetaDataFile(String directory, String rrdName, Map<String, String> attributeMappings) {
        File metaFile = new File(directory + File.separator + rrdName + ".meta");
        try {
            if (metaFile.exists()) {
                s_cache.updateProperties(metaFile, attributeMappings);
            } else {
                s_cache.saveProperties(metaFile, attributeMappings);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to save metadata file {}", (Object)metaFile, (Object)e);
        }
    }

    public static Map<String, String> readMetaDataFile(String directory, String rrdName) {
        File metaFile = new File(directory + File.separator + rrdName + ".meta");
        try {
            Properties props = s_cache.getProperties(metaFile);
            HashMap<String, String> ret = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                Object value = entry.getValue();
                ret.put(entry.getKey().toString(), value == null ? null : value.toString());
            }
            return ret;
        }
        catch (IOException e) {
            LOG.warn("Failed to retrieve metadata from {}", (Object)metaFile, (Object)e);
            return Collections.emptyMap();
        }
    }

    public static <D, F> RrdStrategy<D, F> getStrategy() {
        RrdStrategy retval = null;
        retval = m_rrdStrategy == null ? (((Boolean)m_context.getBean("useQueue")).booleanValue() ? (((Boolean)m_context.getBean("useTcp")).booleanValue() ? (RrdStrategy)m_context.getBean(StrategyName.tcpAndQueuingRrdStrategy.toString()) : (RrdStrategy)m_context.getBean(StrategyName.queuingRrdStrategy.toString())) : (((Boolean)m_context.getBean("useTcp")).booleanValue() ? (RrdStrategy)m_context.getBean(StrategyName.tcpAndBasicRrdStrategy.toString()) : (RrdStrategy)m_context.getBean(StrategyName.basicRrdStrategy.toString()))) : m_rrdStrategy;
        if (retval == null) {
            throw new IllegalStateException("RrdUtils not initialized");
        }
        return retval;
    }

    public static <D, F> RrdStrategy<D, F> getSpecificStrategy(StrategyName strategy) {
        RrdStrategy retval = null;
        retval = (RrdStrategy)m_context.getBean(strategy.toString());
        if (retval == null) {
            throw new IllegalStateException("RrdUtils not initialized");
        }
        return retval;
    }

    public static void setStrategy(RrdStrategy<?, ?> strategy) {
        m_rrdStrategy = strategy;
    }

    public static boolean createRRD(String creator, String directory, String dsName, int step, String dsType, int dsHeartbeat, String dsMin, String dsMax, List<String> rraList, Map<String, String> attributeMappings) throws RrdException {
        return RrdUtils.createRRD(creator, directory, dsName, step, Collections.singletonList(new RrdDataSource(dsName, dsType, dsHeartbeat, dsMin, dsMax)), rraList, attributeMappings);
    }

    public static boolean createRRD(String creator, String directory, String dsName, int step, String dsType, int dsHeartbeat, String dsMin, String dsMax, List<String> rraList) throws RrdException {
        return RrdUtils.createRRD(creator, directory, dsName, step, Collections.singletonList(new RrdDataSource(dsName, dsType, dsHeartbeat, dsMin, dsMax)), rraList, null);
    }

    public static boolean createRRD(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws RrdException {
        return RrdUtils.createRRD(creator, directory, rrdName, step, dataSources, rraList, null);
    }

    public static boolean createRRD(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList, Map<String, String> attributeMappings) throws RrdException {
        Object def = null;
        try {
            def = RrdUtils.getStrategy().createDefinition(creator, directory, rrdName, step, dataSources, rraList);
            RrdUtils.getStrategy().createFile(def, attributeMappings);
            return true;
        }
        catch (Throwable e) {
            String path = directory + File.separator + rrdName + RrdUtils.getStrategy().getDefaultFileExtension();
            LOG.error("createRRD: An error occurred creating rrdfile {}", (Object)path, (Object)e);
            throw new RrdException("An error occurred creating rrdfile " + path + ": " + e, e);
        }
    }

    public static void updateRRD(String owner, String repositoryDir, String rrdName, String val) throws RrdException {
        RrdUtils.updateRRD(owner, repositoryDir, rrdName, System.currentTimeMillis(), val);
    }

    public static void updateRRD(String owner, String repositoryDir, String rrdName, long timestamp, String val) throws RrdException {
        String rrdFile = repositoryDir + File.separator + rrdName + RrdUtils.getExtension();
        long time = (timestamp + 500L) / 1000L;
        String updateVal = Long.toString(time) + ":" + val;
        LOG.info("updateRRD: updating RRD file {} with values '{}'", (Object)rrdFile, (Object)updateVal);
        Object rrd = null;
        try {
            rrd = RrdUtils.getStrategy().openFile(rrdFile);
            RrdUtils.getStrategy().updateFile(rrd, owner, updateVal);
        }
        catch (Throwable e) {
            LOG.error("updateRRD: Error updating RRD file {} with values '{}'", new Object[]{rrdFile, updateVal, e});
            throw new RrdException("Error updating RRD file " + rrdFile + " with values '" + updateVal + "': " + e, e);
        }
        finally {
            try {
                if (rrd != null) {
                    RrdUtils.getStrategy().closeFile(rrd);
                }
            }
            catch (Throwable e) {
                LOG.error("updateRRD: Exception closing RRD file {}", (Object)rrdFile, (Object)e);
                throw new RrdException("Exception closing RRD file " + rrdFile + ": " + e, e);
            }
        }
        LOG.debug("updateRRD: RRD update command completed.");
    }

    public static Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException, RrdException {
        return RrdUtils.getStrategy().fetchLastValue(rrdFile, ds, interval);
    }

    public static Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException, RrdException {
        return RrdUtils.getStrategy().fetchLastValueInRange(rrdFile, ds, interval, range);
    }

    public static InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        return RrdUtils.getStrategy().createGraph(command, workDir);
    }

    public static String getExtension() {
        String rrdExtension = (String)m_context.getBean("rrdFileExtension");
        if (rrdExtension == null || "".equals(rrdExtension)) {
            return RrdUtils.getStrategy().getDefaultFileExtension();
        }
        return rrdExtension;
    }

    public static void promoteEnqueuedFiles(Collection<String> files) {
        RrdUtils.getStrategy().promoteEnqueuedFiles(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader old = null;
        try {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(RrdUtils.class.getClassLoader());
            m_context = new ClassPathXmlApplicationContext(new String[]{"/org/opennms/netmgt/rrd/rrd-configuration.xml"}, RrdUtils.class);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public static enum StrategyName {
        basicRrdStrategy,
        queuingRrdStrategy,
        tcpAndBasicRrdStrategy,
        tcpAndQueuingRrdStrategy;

    }
}

