/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.config.api.collection.IGroup;
import org.opennms.netmgt.config.api.collection.ISystemDef;
import org.opennms.netmgt.config.api.collection.ITable;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionInitializationCache;
import org.opennms.netmgt.sampler.config.snmp.Group;
import org.opennms.netmgt.sampler.config.snmp.SnmpAgent;
import org.opennms.netmgt.sampler.config.snmp.SnmpCollectionRequest;
import org.opennms.netmgt.sampler.config.snmp.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="datacollection-group")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SystemDef
implements ISystemDef {
    private static final Logger LOG = LoggerFactory.getLogger(SystemDef.class);
    private static final Table[] EMPTY_TABLE_ARRAY = new Table[0];
    private static final Group[] EMPTY_GROUP_ARRAY = new Group[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    @XmlAttribute(name="name")
    private String m_name;
    @XmlElement(name="sysoidMask")
    private String m_sysoidMask;
    @XmlElement(name="sysoid")
    private String m_sysoid;
    @XmlElementWrapper(name="collect")
    @XmlElement(name="include")
    private List<String> m_includes = new ArrayList<String>();
    @XmlTransient
    private List<Table> m_tables = new ArrayList<Table>();
    @XmlTransient
    private List<Group> m_groups = new ArrayList<Group>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getSysoidMask() {
        return this.m_sysoidMask;
    }

    public void setSysoidMask(String sysoidMask) {
        this.m_sysoidMask = sysoidMask;
    }

    public String getSysoid() {
        return this.m_sysoid;
    }

    public void setSysoid(String sysoid) {
        this.m_sysoid = sysoid;
    }

    public String[] getIncludes() {
        return this.m_includes == null ? EMPTY_STRING_ARRAY : this.m_includes.toArray(EMPTY_STRING_ARRAY);
    }

    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.m_includes.clear();
        } else {
            this.m_includes = Arrays.asList(includes);
        }
    }

    public ITable[] getTables() {
        return this.m_tables == null ? EMPTY_TABLE_ARRAY : this.m_tables.toArray(EMPTY_TABLE_ARRAY);
    }

    public void setTables(ITable[] tables) {
        if (tables == null) {
            this.m_tables.clear();
        } else {
            this.m_tables = Arrays.asList(Table.asTables(tables));
        }
    }

    public IGroup[] getGroups() {
        return this.m_groups == null ? EMPTY_GROUP_ARRAY : this.m_groups.toArray(EMPTY_GROUP_ARRAY);
    }

    public void setGroups(IGroup[] groups) {
        if (groups == null) {
            this.m_groups.clear();
        } else {
            this.m_groups = Arrays.asList(Group.asGroups(groups));
        }
    }

    public void initialize(DataCollectionInitializationCache cache) {
        LOG.debug("{} initializing", (Object)this.m_name);
        for (String include : this.m_includes) {
            if (cache.hasTable(include)) {
                Table table = Table.asTable(cache.getTable(include));
                this.addTable(table);
                continue;
            }
            if (cache.hasGroup(include)) {
                this.addGroup(Group.asGroup(cache.getGroup(include)));
                continue;
            }
            throw new IllegalArgumentException("Unable to locate include " + include + " for systemDef " + this.getName());
        }
        LOG.debug("{} finished initializing", (Object)this.m_name);
    }

    protected void addTable(Table table) {
        for (Table t : this.m_tables) {
            if (!t.getName().equals(table.getName())) continue;
            LOG.trace("Table {} already added.", (Object)table.getName());
            return;
        }
        this.m_tables.add(table);
    }

    protected void addGroup(Group group) {
        for (Group g : this.m_groups) {
            if (!g.getName().equals(group.getName())) continue;
            LOG.trace("Group {} already added.", (Object)group.getName());
            return;
        }
        this.m_groups.add(group);
    }

    public boolean matches(SnmpAgent agent) {
        String systemObjId = agent.getSysObjectId();
        if (this.m_sysoid == null && this.m_sysoidMask == null) {
            LOG.debug("SystemDef {} has no oid *or* mask, always matches!", (Object)this.m_name);
            return true;
        }
        if (systemObjId == null) {
            LOG.debug("Agent {} has no sysObjectId!", (Object)agent);
            return true;
        }
        if (this.m_sysoid != null && systemObjId.equals(this.m_sysoid)) {
            LOG.debug("Agent matches sysoid {}: {}", (Object)this.m_sysoid, (Object)agent);
            return true;
        }
        if (this.m_sysoidMask != null && systemObjId.startsWith(this.m_sysoidMask)) {
            LOG.debug("Agent matches sysoidMask {}: {}", (Object)this.m_sysoidMask, (Object)agent);
            return true;
        }
        LOG.debug("Agent does not match sysoid={}, sysoidMask={}: {}", new Object[]{this.m_sysoid, this.m_sysoidMask, agent});
        return false;
    }

    public void fillRequest(SnmpCollectionRequest request) {
        this.assertInitialized();
        if (!this.matches(request.getAgent())) {
            return;
        }
        for (Table table : this.m_tables) {
            table.fillRequest(request);
        }
        for (Group group : this.m_groups) {
            group.fillRequest(request);
        }
    }

    private void assertInitialized() {
        if (this.m_tables == null || this.m_groups == null) {
            throw new IllegalStateException("systemDef " + this.getName() + " is not initialized!");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("SystemDef[");
        buf.append("name=").append(this.m_name).append(", ");
        if (this.m_sysoid != null) {
            buf.append("sysoid=").append(this.m_sysoid);
        } else if (this.m_sysoidMask != null) {
            buf.append("sysoidMask=").append(this.m_sysoidMask);
        } else {
            buf.append("No Match Criteria");
        }
        buf.append("]");
        return buf.toString();
    }

    public static SystemDef asSystemDef(ISystemDef systemDef) {
        if (systemDef == null) {
            return null;
        }
        SystemDef newDef = new SystemDef();
        newDef.setName(systemDef.getName());
        newDef.setSysoidMask(systemDef.getSysoidMask());
        newDef.setSysoid(systemDef.getSysoid());
        newDef.setIncludes(systemDef.getIncludes());
        newDef.setTables(systemDef.getTables());
        return newDef;
    }

    public static SystemDef[] asSystemDefs(ISystemDef[] systemDefs) {
        if (systemDefs == null) {
            return null;
        }
        SystemDef[] newDefs = new SystemDef[systemDefs.length];
        for (int i = 0; i < systemDefs.length; ++i) {
            newDefs[i] = SystemDef.asSystemDef(systemDefs[i]);
        }
        return newDefs;
    }
}

