/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.MetricType;
import org.opennms.netmgt.api.sample.NanValue;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.api.sample.SampleSet;
import org.opennms.netmgt.api.sample.SampleValue;
import org.opennms.netmgt.config.api.collection.IGroup;
import org.opennms.netmgt.config.api.collection.IMibObject;
import org.opennms.netmgt.sampler.config.snmp.Group;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SingleInstanceTracker;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpObjIdXmlAdapter;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="mibObj")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MibObject
implements IMibObject {
    protected static final Logger LOG = LoggerFactory.getLogger(MibObject.class);
    @XmlAttribute(name="oid")
    @XmlJavaTypeAdapter(value=SnmpObjIdXmlAdapter.class)
    private SnmpObjId m_oid;
    @XmlAttribute(name="alias")
    private String m_alias;
    @XmlAttribute(name="type")
    private String m_type;
    @XmlAttribute(name="instance")
    private String m_instance;
    @XmlTransient
    private Group m_group;

    public SnmpObjId getOid() {
        return this.m_oid;
    }

    public void setOid(SnmpObjId oid) {
        this.m_oid = oid;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getInstance() {
        return this.m_instance;
    }

    public void setInstance(String instance) {
        this.m_instance = instance;
    }

    public IGroup getGroup() {
        return this.m_group;
    }

    public void setGroup(IGroup group) {
        this.m_group = Group.asGroup(group);
    }

    public MetricType getMetricType() {
        String type = this.getType().toLowerCase();
        if (type.startsWith("counter")) {
            return MetricType.COUNTER;
        }
        if (type.startsWith("gauge")) {
            return MetricType.GAUGE;
        }
        if (type.startsWith("integer")) {
            return MetricType.GAUGE;
        }
        if (type.startsWith("timeticks")) {
            return MetricType.GAUGE;
        }
        return null;
    }

    public Metric createMetric() {
        MetricType type = this.getMetricType();
        if (type == null) {
            return null;
        }
        return new Metric(this.getAlias(), type, this.m_group.getName());
    }

    public CollectionTracker createCollectionTracker(final Resource resource, final SampleSet sampleSet) {
        return new SingleInstanceTracker(this.m_oid, new SnmpInstId(this.m_instance)){

            protected void storeResult(SnmpResult res) {
                Metric metric = MibObject.this.createMetric();
                if (metric == null) {
                    String errorMessage = "Unable to create metric for SnmpResult " + res + "!";
                    LOG.error(errorMessage + " (type={}, alias={}, metricType={}, group={})", new Object[]{MibObject.this.getType(), MibObject.this.getAlias(), MibObject.this.getMetricType(), MibObject.this.m_group});
                    throw new IllegalArgumentException(errorMessage);
                }
                MetricType type = metric.getType();
                if (type == null) {
                    String errorMessage = "Unable to determine type for SnmpResult " + res + "!";
                    LOG.error(errorMessage);
                    throw new IllegalArgumentException(errorMessage);
                }
                SnmpValue value = res.getValue();
                Object sampleValue = value == null ? new NanValue() : type.getValue((Number)value.toBigInteger());
                sampleSet.addMeasurement(resource, metric, (SampleValue)sampleValue);
            }
        };
    }

    public void initialize(Group group) {
        LOG.debug("{} initializing", (Object)this.m_oid);
        this.m_group = group;
        LOG.debug("{} finished initializing", (Object)this.m_oid);
    }

    public static MibObject[] asMibObjects(IMibObject[] mibObjects) {
        if (mibObjects == null) {
            return null;
        }
        MibObject[] newMibObjects = new MibObject[mibObjects.length];
        for (int i = 0; i < mibObjects.length; ++i) {
            newMibObjects[i] = MibObject.asMibObject(mibObjects[i]);
        }
        return newMibObjects;
    }

    private static MibObject asMibObject(IMibObject obj) {
        if (obj == null) {
            return null;
        }
        MibObject mibObject = new MibObject();
        mibObject.setOid(obj.getOid());
        mibObject.setAlias(obj.getAlias());
        mibObject.setType(obj.getType());
        mibObject.setInstance(obj.getInstance());
        mibObject.setGroup(obj.getGroup());
        return mibObject;
    }
}

