/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionGroup;
import org.opennms.netmgt.sampler.config.snmp.Group;
import org.opennms.netmgt.sampler.config.snmp.ResourceType;
import org.opennms.netmgt.sampler.config.snmp.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCollectionInitializationCache {
    private static final Logger LOG = LoggerFactory.getLogger(DataCollectionInitializationCache.class);
    private final Map<String, DataCollectionGroup> m_dataCollectionGroups = new LinkedHashMap<String, DataCollectionGroup>();
    private final Map<String, ResourceType> m_types = new LinkedHashMap<String, ResourceType>();
    private final Map<String, Table> m_tables = new LinkedHashMap<String, Table>();
    private final Map<String, Group> m_groups = new LinkedHashMap<String, Group>();

    public void prepare() {
        for (DataCollectionGroup group : this.m_dataCollectionGroups.values()) {
            group.gatherSymbols(this);
        }
        for (DataCollectionGroup group : this.m_dataCollectionGroups.values()) {
            group.initialize(this);
        }
    }

    public DataCollectionGroup getDataCollectionGroup(String groupName) throws IllegalArgumentException {
        if (!this.m_dataCollectionGroups.containsKey(groupName)) {
            throw new IllegalArgumentException("Unable to locate DataCollectionGroup " + groupName + " in the data collection cache!");
        }
        return this.m_dataCollectionGroups.get(groupName);
    }

    public void addDataCollectionGroup(DataCollectionGroup group) {
        String name = group.getName();
        if (this.m_dataCollectionGroups.containsKey(name)) {
            LOG.trace("Duplicate DataCollectionGroup: {} - ignoring.", (Object)name);
            return;
        }
        LOG.trace("Adding group {} to the datacollection cache.", (Object)name);
        this.m_dataCollectionGroups.put(name, group);
    }

    public void addType(ResourceType type) {
        String name = type.getTypeName();
        if (this.m_types.containsKey(name)) {
            LOG.trace("Duplicate ResourceType: {} - ignoring.", (Object)name);
            return;
        }
        LOG.trace("Adding type {} to the datacollection cache.", (Object)name);
        this.m_types.put(name, type);
    }

    public void addTable(Table table) {
        String name = table.getName();
        if (this.m_tables.containsKey(name)) {
            LOG.trace("Duplicate Table: {} - ignoring.", (Object)name);
            return;
        }
        LOG.trace("Adding table {} to the datacollection cache.", (Object)name);
        this.m_tables.put(name, table);
    }

    public void addGroup(Group group) {
        String name = group.getName();
        if (this.m_groups.containsKey(name)) {
            LOG.trace("Duplicate Group: {} - ignoring", (Object)name);
            return;
        }
        LOG.trace("Adding group {} to the datacollection cache.", (Object)name);
        this.m_groups.put(name, group);
    }

    public Collection<DataCollectionGroup> getDataCollectionGroups() {
        return this.m_dataCollectionGroups.values();
    }

    public Collection<ResourceType> getTypes() {
        return this.m_types.values();
    }

    public Collection<Table> getTables() {
        return this.m_tables.values();
    }

    public Collection<Group> getGroups() {
        return this.m_groups.values();
    }

    public boolean hasType(String name) {
        return this.m_types.containsKey(name);
    }

    public ResourceType getType(String name) {
        if (!this.m_types.containsKey(name)) {
            throw new IllegalArgumentException("Unable to locate resourceType " + name + "!");
        }
        return this.m_types.get(name);
    }

    public boolean hasTable(String name) {
        return this.m_tables.containsKey(name);
    }

    public Table getTable(String name) {
        if (!this.m_tables.containsKey(name)) {
            throw new IllegalArgumentException("Unable to locate Table " + name + "!");
        }
        return this.m_tables.get(name);
    }

    public boolean hasGroup(String name) {
        return this.m_groups.containsKey(name);
    }

    public Group getGroup(String name) {
        if (!this.m_groups.containsKey(name)) {
            throw new IllegalArgumentException("Unable to locate Group " + name + "!");
        }
        return this.m_groups.get(name);
    }

    public String toString() {
        return "DataCollectionInitializationCache[dataCollectionGroups=" + this.m_dataCollectionGroups.keySet() + ",types=" + this.m_types.keySet() + ",tables=" + this.m_tables.keySet() + ",groups=" + this.m_groups.keySet() + "]";
    }
}

