/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.config.api.collection.IDataCollectionGroup;
import org.opennms.netmgt.config.api.collection.IGroup;
import org.opennms.netmgt.config.api.collection.IResourceType;
import org.opennms.netmgt.config.api.collection.ISystemDef;
import org.opennms.netmgt.config.api.collection.ITable;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionInitializationCache;
import org.opennms.netmgt.sampler.config.snmp.Group;
import org.opennms.netmgt.sampler.config.snmp.ResourceType;
import org.opennms.netmgt.sampler.config.snmp.SnmpCollectionRequest;
import org.opennms.netmgt.sampler.config.snmp.SystemDef;
import org.opennms.netmgt.sampler.config.snmp.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="datacollection-group")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DataCollectionGroup
implements IDataCollectionGroup {
    private static final Logger LOG = LoggerFactory.getLogger(DataCollectionGroup.class);
    private static final IGroup[] EMPTY_GROUP_ARRAY = new IGroup[0];
    private static final ITable[] EMPTY_TABLE_ARRAY = new ITable[0];
    private static final IResourceType[] EMPTY_RESOURCE_TYPE_ARRAY = new IResourceType[0];
    private static final ISystemDef[] EMPTY_SYSTEM_DEF_ARRAY = new ISystemDef[0];
    @XmlAttribute(name="name")
    String m_name;
    @XmlElement(name="resourceType")
    List<ResourceType> m_resourceTypes = new ArrayList<ResourceType>();
    @XmlElement(name="table")
    List<Table> m_tables = new ArrayList<Table>();
    @XmlElement(name="group")
    List<Group> m_groups = new ArrayList<Group>();
    @XmlElement(name="systemDef")
    List<SystemDef> m_systemDefs = new ArrayList<SystemDef>();

    public IGroup[] getGroups() {
        return this.m_groups.toArray(EMPTY_GROUP_ARRAY);
    }

    public ITable[] getTables() {
        return this.m_tables.toArray(EMPTY_TABLE_ARRAY);
    }

    public ISystemDef[] getSystemDefs() {
        return this.m_systemDefs.toArray(EMPTY_SYSTEM_DEF_ARRAY);
    }

    public IResourceType[] getResourceTypes() {
        return this.m_resourceTypes.toArray(EMPTY_RESOURCE_TYPE_ARRAY);
    }

    public String getName() {
        return this.m_name;
    }

    public void initialize(DataCollectionInitializationCache cache) {
        LOG.debug("{} initializing using cache: {}", (Object)this.m_name, (Object)cache);
        for (Table table : this.m_tables) {
            table.initialize(cache);
        }
        for (Group group : this.m_groups) {
            group.initialize(cache);
        }
        for (SystemDef def : this.m_systemDefs) {
            def.initialize(cache);
        }
        LOG.debug("{} finished initializing", (Object)this.m_name);
    }

    public void fillRequest(SnmpCollectionRequest request) {
        for (SystemDef systemDef : this.m_systemDefs) {
            systemDef.fillRequest(request);
        }
    }

    public void gatherSymbols(DataCollectionInitializationCache cache) {
        for (ResourceType resourceType : this.m_resourceTypes) {
            cache.addType(resourceType);
        }
        for (Table table : this.m_tables) {
            cache.addTable(table);
        }
        for (Group group : this.m_groups) {
            cache.addGroup(group);
        }
    }

    public Set<Metric> getMetricsForGroup(String groupName) {
        for (Table table : this.m_tables) {
            if (!groupName.equals(table.getName())) continue;
            return table.getMetrics();
        }
        for (Group group : this.m_groups) {
            if (!groupName.equals(group.getName())) continue;
            return group.getMetrics();
        }
        LOG.trace("No metrics found for group {}", (Object)groupName);
        return null;
    }

    public Metric getMetric(String metricName) {
        Metric metric;
        for (Table table : this.m_tables) {
            metric = table.getMetric(metricName);
            if (metric == null) continue;
            return metric;
        }
        for (Group group : this.m_groups) {
            metric = group.getMetric(metricName);
            if (metric == null) continue;
            return metric;
        }
        LOG.trace("No metric found: {}", (Object)metricName);
        return null;
    }

    public static DataCollectionGroup asCollectionGroup(IDataCollectionGroup group) {
        if (group == null) {
            return null;
        }
        if (group instanceof DataCollectionGroup) {
            return (DataCollectionGroup)group;
        }
        DataCollectionGroup dcg = new DataCollectionGroup();
        dcg.m_name = group.getName();
        dcg.m_resourceTypes = Arrays.asList(ResourceType.asResourceTypes(group.getResourceTypes()));
        dcg.m_tables = Arrays.asList(Table.asTables(group.getTables()));
        dcg.m_groups = Arrays.asList(Group.asGroups(group.getGroups()));
        dcg.m_systemDefs = Arrays.asList(SystemDef.asSystemDefs(group.getSystemDefs()));
        return dcg;
    }

    public static DataCollectionGroup[] asCollectionGroups(IDataCollectionGroup[] groups) {
        if (groups == null) {
            return null;
        }
        DataCollectionGroup[] newGroups = new DataCollectionGroup[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            newGroups[i] = DataCollectionGroup.asCollectionGroup(groups[i]);
        }
        return newGroups;
    }

    public String toString() {
        return "DataCollectionGroup[name=" + this.m_name + ",resourceTypes=" + this.m_resourceTypes + ",tables=" + this.m_tables + ",groups=" + this.m_groups + ",systemDefs=" + this.m_systemDefs + "]";
    }
}

