/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.MetricType;
import org.opennms.netmgt.config.api.collection.IColumn;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpObjIdXmlAdapter;
import org.opennms.netmgt.snmp.SnmpValue;

@XmlRootElement(name="column")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Column
implements IColumn {
    private static final int BASE_10 = 10;
    @XmlAttribute(name="oid")
    @XmlJavaTypeAdapter(value=SnmpObjIdXmlAdapter.class)
    private SnmpObjId m_oid;
    @XmlAttribute(name="alias")
    private String m_alias;
    @XmlAttribute(name="type")
    private String m_type;
    @XmlAttribute(name="display-hint")
    private String m_displayHint;

    public SnmpObjId getOid() {
        return this.m_oid;
    }

    public void setOid(SnmpObjId oid) {
        this.m_oid = oid;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getDisplayHint() {
        return this.m_displayHint;
    }

    public void setDisplayHint(String displayHint) {
        this.m_displayHint = displayHint;
    }

    public MetricType getMetricType() {
        String type = this.getType().toLowerCase();
        if (type.startsWith("counter")) {
            return MetricType.COUNTER;
        }
        if (type.startsWith("gauge")) {
            return MetricType.GAUGE;
        }
        if (type.startsWith("integer")) {
            return MetricType.GAUGE;
        }
        return null;
    }

    public Metric createMetric(String groupName) {
        MetricType type = this.getMetricType();
        if (type == null) {
            return null;
        }
        return new Metric(this.getAlias(), type, groupName);
    }

    private static String formatInteger(String displayHint, long val) {
        if (displayHint.equals("x")) {
            return Long.toHexString(val);
        }
        if (displayHint.equals("o")) {
            return Long.toOctalString(val);
        }
        if (displayHint.equals("b")) {
            return Long.toBinaryString(val);
        }
        if (displayHint.equals("d")) {
            return Long.toString(val);
        }
        if (displayHint.startsWith("d")) {
            int moveLeft = Integer.decode(displayHint.substring(2));
            double result = (double)val / Math.pow(10.0, moveLeft);
            return String.format("%." + moveLeft + "f", result);
        }
        return Long.toString(val);
    }

    public static String formatOctetString(String displayHint, byte[] bytes) {
        OctetStringDisplayHintParser parser = new OctetStringDisplayHintParser(displayHint);
        parser.parse();
        return parser.apply(bytes);
    }

    public String getValue(SnmpValue val) {
        String displayHint = this.m_displayHint;
        if (displayHint == null) {
            return val.toDisplayString();
        }
        if (val.getType() == 4) {
            return Column.formatOctetString(this.m_displayHint, val.getBytes());
        }
        if (val.getType() == 2) {
            return Column.formatInteger(this.m_displayHint, val.toLong());
        }
        return val.toDisplayString();
    }

    public static Column asColumn(IColumn column) {
        if (column == null) {
            return null;
        }
        if (column instanceof Column) {
            return (Column)column;
        }
        Column newColumn = new Column();
        newColumn.setOid(column.getOid());
        newColumn.setAlias(column.getAlias());
        newColumn.setType(column.getType());
        newColumn.setDisplayHint(column.getDisplayHint());
        return newColumn;
    }

    public static Column[] asColumns(IColumn[] columns) {
        if (columns == null) {
            return null;
        }
        Column[] newColumns = new Column[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            newColumns[i] = Column.asColumn(columns[i]);
        }
        return newColumns;
    }

    private static class OctetStringDisplayHintParser {
        private final String m_displayHint;
        private int m_current;
        private List<OctetFormatSpecifier> m_formatSpecifiers = new ArrayList<OctetFormatSpecifier>();

        public OctetStringDisplayHintParser(String displayHint) {
            this.m_displayHint = displayHint;
            this.m_current = 0;
        }

        public void parse() {
            while (this.hasMore()) {
                OctetFormatSpecifier specifier = new OctetFormatSpecifier();
                this.repeatIndicator(specifier);
                this.octetCount(specifier);
                this.displayFormat(specifier);
                if (this.displaySeparator(specifier)) {
                    this.repeatTerminator(specifier);
                }
                this.add(specifier);
            }
        }

        public String apply(byte[] bytes) {
            int index = 0;
            int currentSpecifier = 0;
            OctetFormatSpecifier specifier = this.m_formatSpecifiers.get(currentSpecifier);
            StringBuilder buf = new StringBuilder();
            while (index < bytes.length) {
                index = specifier.apply(bytes, index, buf);
                currentSpecifier = Math.min(currentSpecifier + 1, this.m_formatSpecifiers.size() - 1);
                specifier = this.m_formatSpecifiers.get(currentSpecifier);
            }
            return buf.toString();
        }

        private boolean displaySeparator(OctetFormatSpecifier specifier) {
            if (this.hasMore() && !this.isDigit(this.peek()) && this.peek() != '*') {
                char displaySeparator = this.peek();
                this.match(displaySeparator);
                specifier.setDisplaySeparator(displaySeparator);
                return true;
            }
            return false;
        }

        private void repeatTerminator(OctetFormatSpecifier specifier) {
            if (this.hasMore() && !this.isDigit(this.peek()) && this.peek() != '*') {
                char repeatTerminator = this.peek();
                this.match(repeatTerminator);
                specifier.setRepeatTerminator(repeatTerminator);
            }
        }

        private void displayFormat(OctetFormatSpecifier specifier) {
            if (!this.in(this.peek(), "axodt")) {
                throw new IllegalArgumentException("Expected display format char at index " + this.m_current + " of \"" + this.m_displayHint + "\" but found character " + this.peek());
            }
            char displayFormat = this.peek();
            this.match(displayFormat);
            specifier.setDisplayFormat(displayFormat);
        }

        private void octetCount(OctetFormatSpecifier specifier) {
            int octetCount;
            if (this.isDigit(this.peek())) {
                octetCount = 0;
                while (this.isDigit(this.peek())) {
                    char digitChar = this.peek();
                    this.match(digitChar);
                    int digit = digitChar - 48;
                    octetCount = octetCount * 10 + digit;
                }
            } else {
                throw new IllegalArgumentException("Expected digit at index " + this.m_current + " of \"" + this.m_displayHint + "\" but found character " + this.peek());
            }
            specifier.setOctetCount(octetCount);
        }

        private void repeatIndicator(OctetFormatSpecifier specifier) {
            if (this.peek() == '*') {
                this.match('*');
                specifier.setRepeatIndicator(true);
            }
        }

        private void add(OctetFormatSpecifier specifier) {
            this.m_formatSpecifiers.add(specifier);
        }

        private boolean isDigit(char ch) {
            return this.in(ch, "0123456789");
        }

        private boolean in(char ch, String set) {
            return set.indexOf(ch) >= 0;
        }

        private void match(char matchChar) {
            if (!this.hasMore()) {
                throw new IllegalArgumentException("Unexpected End of String for display hint \"" + this.m_displayHint + "\"");
            }
            char c = this.m_displayHint.charAt(this.m_current);
            if (c != matchChar) {
                throw new IllegalArgumentException("Unexpected character '" + c + "' at index " + this.m_current + " of display hint \"" + this.m_displayHint + "\"");
            }
            ++this.m_current;
        }

        private boolean hasMore() {
            return this.m_current < this.m_displayHint.length();
        }

        private char peek() {
            return this.m_displayHint.charAt(this.m_current);
        }
    }

    private static class OctetFormatSpecifier {
        private static final long MAX_8BITS = 255L;
        private static final Charset UTF_8 = Charset.forName("UTF-8");
        private boolean m_repeatIndicator = false;
        private int m_octetCount = 2;
        private char m_displayFormat = (char)97;
        private char m_displaySeparator = '\u0000';
        private char m_repeatTerminator = '\u0000';

        private OctetFormatSpecifier() {
        }

        public boolean hasRepeatIndicator() {
            return this.m_repeatIndicator;
        }

        public void setRepeatIndicator(boolean repeatIndicator) {
            this.m_repeatIndicator = repeatIndicator;
        }

        public int getOctetCount() {
            return this.m_octetCount;
        }

        public void setOctetCount(int octetCount) {
            this.m_octetCount = octetCount;
        }

        public char getDisplayFormat() {
            return this.m_displayFormat;
        }

        public void setDisplayFormat(char displayFormat) {
            this.m_displayFormat = displayFormat;
        }

        public char getDisplaySeparator() {
            return this.m_displaySeparator;
        }

        public void setDisplaySeparator(char displaySeparator) {
            this.m_displaySeparator = displaySeparator;
        }

        public char getRepeatTerminator() {
            return this.m_repeatTerminator;
        }

        public void setRepeatTerminator(char repeatTerminator) {
            this.m_repeatTerminator = repeatTerminator;
        }

        public boolean hasDisplaySeparator() {
            return this.getDisplaySeparator() != '\u0000';
        }

        public boolean hasRepeatTerminator() {
            return this.getRepeatTerminator() != '\u0000';
        }

        public int apply(byte[] bytes, int index, StringBuilder buf) {
            int myIndex = index;
            int repeat = this.hasRepeatIndicator() ? bytes[myIndex++] : 1;
            for (int i = 0; i < repeat; ++i) {
                if ((myIndex = this.applyFormat(bytes, myIndex, buf)) >= bytes.length || !this.hasDisplaySeparator() || this.hasRepeatTerminator() && i >= repeat - 1) continue;
                buf.append(this.getDisplaySeparator());
            }
            if (myIndex < bytes.length && this.hasRepeatTerminator()) {
                buf.append(this.getRepeatTerminator());
            }
            return myIndex;
        }

        private int applyFormat(byte[] bytes, int index, StringBuilder buf) {
            int myIndex = index;
            if (this.getDisplayFormat() == 'a') {
                for (int i = 0; i < this.getOctetCount() && myIndex < bytes.length; ++i) {
                    buf.append((char)bytes[myIndex++]);
                }
            } else if (this.getDisplayFormat() == 't') {
                int decodeLen = Math.min(this.getOctetCount(), bytes.length - myIndex);
                byte[] decode = new byte[decodeLen];
                System.arraycopy(bytes, myIndex, decode, 0, decodeLen);
                String result = new String(decode, UTF_8);
                buf.append(result);
                myIndex += decodeLen;
            } else {
                long val = 0L;
                for (int i = 0; i < this.getOctetCount() && myIndex < bytes.length; ++i) {
                    val = (val << 8) + ((long)bytes[myIndex++] & 0xFFL);
                }
                if (this.getDisplayFormat() == 'd') {
                    buf.append(Long.toString(val));
                } else if (this.getDisplayFormat() == 'x') {
                    String hex = Long.toHexString(val);
                    for (int i = 0; i < 2 * this.getOctetCount() - hex.length(); ++i) {
                        buf.append('0');
                    }
                    buf.append(hex);
                } else if (this.getDisplayFormat() == 'o') {
                    buf.append(Long.toOctalString(val));
                }
            }
            return myIndex;
        }
    }
}

