/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.sampler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.sampler.SamplerCollectionAgent;
import org.opennms.netmgt.collection.support.AbstractCollectionResource;
import org.opennms.netmgt.collection.support.IndexStorageStrategy;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplerCollectionResource
extends AbstractCollectionResource {
    private static final Logger LOG = LoggerFactory.getLogger(SamplerCollectionResource.class);
    private final Resource m_resource;
    private final RrdRepository m_repository;

    public SamplerCollectionResource(Resource resource, RrdRepository repository) {
        super((CollectionAgent)new SamplerCollectionAgent(resource.getAgent()));
        this.m_resource = resource;
        this.m_repository = repository;
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, this.getParent());
        if ("node".equalsIgnoreCase(this.m_resource.getType())) {
            return nodeDir;
        }
        if ("if".equalsIgnoreCase(this.m_resource.getType()) || "ifIndex".equalsIgnoreCase(this.m_resource.getType())) {
            String resourceName = this.m_resource.getName();
            resourceName = resourceName.replaceAll("\\s+", "_").replaceAll(":", "").replaceAll("\\\\", "_").replaceAll("/", "_").replaceAll("[\\[\\]]", "_");
            return new File(nodeDir, resourceName);
        }
        String resourceName = this.m_resource.getName();
        resourceName = resourceName.replaceAll("\\s+", "_").replaceAll(":", "").replaceAll("\\\\", "_").replaceAll("/", "_").replaceAll("[\\[\\]]", "_");
        IndexStorageStrategy strategy = new IndexStorageStrategy();
        strategy.setResourceTypeName(this.m_resource.getType());
        String resourcePath = strategy.getRelativePathForAttribute(this.getParent(), resourceName);
        File resourceDir = new File(repository.getRrdBaseDir(), resourcePath);
        return resourceDir;
    }

    public String getResourceTypeName() {
        return this.m_resource.getType();
    }

    public String getInterfaceLabel() {
        if ("if".equalsIgnoreCase(this.m_resource.getType()) || "ifIndex".equalsIgnoreCase(this.m_resource.getType())) {
            return this.m_resource.getName();
        }
        return null;
    }

    public String getInstance() {
        if ("node".equalsIgnoreCase(this.m_resource.getType()) || "if".equalsIgnoreCase(this.m_resource.getType()) || "ifIndex".equalsIgnoreCase(this.m_resource.getType())) {
            return null;
        }
        return this.m_resource.getName();
    }

    public void visit(CollectionSetVisitor visitor) {
        File resourceDir = this.getResourceDir(this.m_repository);
        this.createResourcePath(resourceDir.toPath());
        for (Map.Entry entry : this.m_resource.getAttributes().entrySet()) {
            try {
                ResourceTypeUtils.updateStringProperty((File)resourceDir, (String)((String)entry.getValue()), (String)((String)entry.getKey()));
            }
            catch (FileNotFoundException e) {
                LOG.error("Unable to save string attribute {}->{}", new Object[]{entry.getKey(), entry.getValue(), e});
            }
            catch (IOException e) {
                LOG.error("Unable to save string attribute {}->{}", new Object[]{entry.getKey(), entry.getValue(), e});
            }
        }
        super.visit(visitor);
    }

    private void createResourcePath(Path resourcePath) {
        if (!Files.exists(resourcePath, new LinkOption[0])) {
            LOG.info("Resource path {} does not exist. Try to create it.", (Object)resourcePath);
            try {
                Files.createDirectories(resourcePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOG.error("Could not create resource path {}. Error: {}", (Object)resourcePath, (Object)e);
            }
        }
    }
}

