/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.sampler;

import java.util.Objects;
import org.opennms.netmgt.api.sample.Sample;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.sampler.SamplerCollectionAttributeType;
import org.opennms.netmgt.collection.sampler.SamplerCollectionResource;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;

public class SamplerCollectionAttribute
extends AbstractCollectionAttribute {
    private final Sample m_sample;

    public SamplerCollectionAttribute(SamplerCollectionAttributeType attribType, SamplerCollectionResource resource, Sample sample) {
        super((CollectionAttributeType)attribType, (CollectionResource)resource);
        Objects.requireNonNull(sample, "Sample cannot be null");
        this.m_sample = sample;
    }

    public String getNumericValue() {
        return String.valueOf(this.m_sample.getValue().doubleValue());
    }

    public String getStringValue() {
        return this.m_sample.getValue().toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.getName() + "=" + this.getStringValue();
    }

    public String getMetricIdentifier() {
        String type = this.m_sample.getResource().getType();
        String group = this.m_sample.getMetric().getGroup();
        String name = this.m_sample.getMetric().getName();
        String metricIdentifier = String.format("%s_%s.%s=%s", type, group, name, name);
        return metricIdentifier;
    }
}

