/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class PropertiesUtils {
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final String PLACEHOLDER_PREFIX = "${";

    public static String substitute(String initialString, Properties ... propertiesArray) {
        String workingString = initialString;
        for (Properties properties : propertiesArray) {
            if (properties == null) continue;
            workingString = PropertiesUtils.substitute(workingString, (SymbolTable)new PropertyBasedSymbolTable(properties), PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, new ArrayList<String>());
        }
        return workingString;
    }

    @SafeVarargs
    public static String substitute(String initialString, Map<String, Object> ... mapArray) {
        for (Map<String, Object> properties : mapArray) {
            HashMap<String, String> convertedProperties = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                Object value = entry.getValue();
                convertedProperties.put(entry.getKey(), value == null ? null : value.toString());
            }
            if (properties == null) continue;
            return PropertiesUtils.substitute(initialString, (SymbolTable)new MapBasedSymbolTable(convertedProperties), PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, new ArrayList<String>());
        }
        return initialString;
    }

    public static String substitute(String initialString, Properties properties, String prefix, String suffix) {
        return PropertiesUtils.substitute(initialString, (SymbolTable)new PropertyBasedSymbolTable(properties), prefix, suffix, new ArrayList<String>());
    }

    public static String substitute(String initialString, SymbolTable ... symbolsArray) {
        String workingString = initialString;
        for (SymbolTable symbols : symbolsArray) {
            workingString = PropertiesUtils.substitute(workingString, symbols, PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, new ArrayList<String>());
        }
        return workingString;
    }

    private static String substitute(String initialString, SymbolTable symTable, String placeholderPrefix, String placeholderSuffix, List<String> list) {
        if (initialString == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(initialString);
        int startIndex = 0;
        while (startIndex >= 0) {
            int endIndex;
            int beginIndex = result.indexOf(placeholderPrefix, startIndex);
            int n = endIndex = beginIndex < 0 ? -1 : result.indexOf(placeholderSuffix, beginIndex + placeholderPrefix.length());
            if (endIndex >= 0) {
                String symbol = result.substring(beginIndex + placeholderPrefix.length(), endIndex);
                if (list.contains(symbol)) {
                    throw new IllegalStateException("recursive loop involving symbol " + placeholderPrefix + symbol + placeholderSuffix);
                }
                String symbolVal = symTable.getSymbolValue(symbol);
                if (symbolVal != null) {
                    list.add(symbol);
                    String substVal = PropertiesUtils.substitute(symbolVal, symTable, placeholderPrefix, placeholderSuffix, list);
                    list.remove(list.size() - 1);
                    result.replace(beginIndex, endIndex + 1, substVal);
                    startIndex = beginIndex + substVal.length();
                    continue;
                }
                startIndex = endIndex + 1;
                continue;
            }
            startIndex = -1;
        }
        return result.toString();
    }

    public static String getProperty(Properties props, String name, String defaultVal) {
        return props.getProperty(name) == null ? defaultVal : props.getProperty(name);
    }

    public static boolean getProperty(Properties props, String name, boolean defaultVal) {
        return "true".equalsIgnoreCase(props.getProperty(name, defaultVal ? "true" : "false"));
    }

    public static int getProperty(Properties props, String name, int defaultVal) {
        String val = props.getProperty(name, null);
        if (val != null) {
            try {
                return Integer.decode(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public static long getProperty(Properties props, String name, long defaultVal) {
        String val = props.getProperty(name, null);
        if (val != null) {
            try {
                return Long.decode(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    private static class MapBasedSymbolTable
    implements SymbolTable {
        Map<String, String> m_map;

        MapBasedSymbolTable(Map<String, String> properties) {
            this.m_map = properties;
        }

        @Override
        public String getSymbolValue(String symbol) {
            return this.m_map.get(symbol);
        }
    }

    private static class PropertyBasedSymbolTable
    implements SymbolTable {
        Properties m_properties;

        PropertyBasedSymbolTable(Properties properties) {
            this.m_properties = properties;
        }

        @Override
        public String getSymbolValue(String symbol) {
            return this.m_properties.getProperty(symbol);
        }
    }

    public static interface SymbolTable {
        public String getSymbolValue(String var1);
    }
}

