/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.ValueType;

public class Counter
extends ValueType<UnsignedLong> {
    private static final long serialVersionUID = 1L;
    private static final UnsignedLong MAX32 = Counter.toUnsignedLong(0xFFFFFFFFL);
    private static final UnsignedLong MAX64 = Counter.toUnsignedLong(-1L);
    private final UnsignedLong m_value;

    public Counter(long value) {
        this(UnsignedLong.fromLongBits((long)value));
    }

    public Counter(UnsignedLong value) {
        this.m_value = (UnsignedLong)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    public Counter plus(Number value) {
        return new Counter(this.getValue().plus(Counter.toUnsignedLong(value)));
    }

    public Counter minus(Number value) {
        return new Counter(this.getValue().minus(Counter.toUnsignedLong(value)));
    }

    @Override
    public ValueType<UnsignedLong> delta(Number value) {
        UnsignedLong difference = this.getValue().minus(Counter.toUnsignedLong(value));
        if (this.isNegative(difference)) {
            UnsignedLong difference32 = difference.plus(MAX32).plus(UnsignedLong.ONE);
            if (this.isNegative(difference32)) {
                return new Counter(difference.plus(MAX64).plus(UnsignedLong.ONE));
            }
            return new Counter(difference32);
        }
        return new Counter(difference);
    }

    private boolean isNegative(UnsignedLong val) {
        return val.compareTo(UnsignedLong.ZERO) < 0;
    }

    public Counter times(Number value) {
        return new Counter(this.getValue().times(Counter.toUnsignedLong(value)));
    }

    public Counter divideBy(Number value) {
        return new Counter(this.getValue().dividedBy(Counter.toUnsignedLong(value)));
    }

    @Override
    UnsignedLong getValue() {
        return this.m_value;
    }

    @Override
    public MetricType getType() {
        return MetricType.COUNTER;
    }

    @Override
    public int intValue() {
        return this.getValue().intValue();
    }

    @Override
    public long longValue() {
        return this.getValue().longValue();
    }

    @Override
    public float floatValue() {
        return this.getValue().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.getValue().doubleValue();
    }

    private static UnsignedLong toUnsignedLong(Number value) {
        if (value instanceof UnsignedLong) {
            return (UnsignedLong)value;
        }
        return UnsignedLong.fromLongBits((long)value.longValue());
    }
}

