/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.hardware;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.hardware.MibObj;

@XmlRootElement(name="hw-extension")
@XmlAccessorType(value=XmlAccessType.NONE)
public class HwExtension
implements Serializable {
    private static final long serialVersionUID = 3230325207779649291L;
    private String name;
    private String sysOidMask;
    private List<MibObj> mibObjects = new ArrayList<MibObj>();

    public HwExtension() {
    }

    public HwExtension(String name, String sysOidMask) {
        this.name = name;
        this.sysOidMask = sysOidMask;
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="sysOidMask", required=true)
    public String getSysOidMask() {
        return this.sysOidMask;
    }

    public void setSysOidMask(String sysOidMask) {
        this.sysOidMask = sysOidMask;
    }

    @XmlElement(name="mibObj", required=true)
    public List<MibObj> getMibObjects() {
        return this.mibObjects;
    }

    public MibObj getMibObjectByAlias(String name) {
        for (MibObj obj : this.mibObjects) {
            if (!obj.getAlias().equals(name)) continue;
            return obj;
        }
        return null;
    }

    public MibObj getMibObjectByOid(String oid) {
        for (MibObj obj : this.mibObjects) {
            if (!obj.getOid().toString().equals(oid)) continue;
            return obj;
        }
        return null;
    }

    public void setMibObjects(List<MibObj> mibObjects) {
        if (mibObjects == null) {
            this.mibObjects.clear();
        } else {
            this.mibObjects = mibObjects;
        }
    }

    public void addMibObject(MibObj mibObj) {
        this.mibObjects.add(mibObj);
    }

    public String toString() {
        return "HwExtension [name=" + this.name + ", sysOidMask=" + this.sysOidMask + ", mibObjects=" + this.mibObjects + "]";
    }
}

