/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Locale;
import org.apache.camel.component.properties.PropertiesFunction;
import org.apache.camel.util.ObjectHelper;

public class ServicePropertiesFunction
implements PropertiesFunction {
    private static final String HOST_PREFIX = "_SERVICE_HOST";
    private static final String PORT_PREFIX = "_SERVICE_PORT";

    @Override
    public String getName() {
        return "service";
    }

    @Override
    public String apply(String remainder) {
        String key = remainder;
        String defaultValue = null;
        if (remainder.contains(":")) {
            key = ObjectHelper.before(remainder, ":");
            defaultValue = ObjectHelper.after(remainder, ":");
        }
        key = key.toUpperCase(Locale.ENGLISH);
        String host = System.getenv(key + HOST_PREFIX);
        String port = System.getenv(key + PORT_PREFIX);
        if (host != null && port != null) {
            return host + ":" + port;
        }
        return defaultValue;
    }
}

