/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.karaf.commands.CamelCommandSupport;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;

@Command(scope="camel", name="route-list", description="List Camel routes.")
public class RouteList
extends CamelCommandSupport {
    private static final String CONTEXT_COLUMN_LABEL = "Context";
    private static final String ROUTE_COLUMN_LABEL = "Route";
    private static final String STATUS_COLUMN_LABEL = "Status";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = Integer.MAX_VALUE;
    private static final int MIN_COLUMN_WIDTH = 12;
    @Argument(index=0, name="name", description="The Camel context name where to look for the route", required=false, multiValued=false)
    String name;

    protected Object doExecute() throws Exception {
        List<Route> routes = this.camelController.getRoutes(this.name);
        Map<String, Integer> columnWidths = RouteList.computeColumnWidths(routes);
        String headerFormat = RouteList.buildFormatString(columnWidths, true);
        String rowFormat = RouteList.buildFormatString(columnWidths, false);
        PrintStream out = System.out;
        if (routes.size() > 0) {
            out.println(String.format(headerFormat, CONTEXT_COLUMN_LABEL, ROUTE_COLUMN_LABEL, STATUS_COLUMN_LABEL));
            out.println(String.format(headerFormat, "-------", "-----", "------"));
            for (Route route : routes) {
                String contextId = route.getRouteContext().getCamelContext().getName();
                String routeId = route.getId();
                ServiceStatus status = route.getRouteContext().getCamelContext().getRouteStatus(routeId);
                out.println(String.format(rowFormat, contextId, routeId, status));
            }
        }
        return null;
    }

    private static Map<String, Integer> computeColumnWidths(Iterable<Route> routes) throws Exception {
        if (routes == null) {
            throw new IllegalArgumentException("Unable to determine column widths from null Iterable<Route>");
        }
        int maxContextLen = 0;
        int maxRouteLen = 0;
        int maxStatusLen = 0;
        for (Route route : routes) {
            String contextId = route.getRouteContext().getCamelContext().getName();
            maxContextLen = Math.max(maxContextLen, contextId == null ? 0 : contextId.length());
            String routeId = route.getId();
            maxRouteLen = Math.max(maxRouteLen, routeId == null ? 0 : routeId.length());
            String status = route.getRouteContext().getCamelContext().getRouteStatus(routeId).name();
            maxStatusLen = Math.max(maxStatusLen, status == null ? 0 : status.length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>(3);
        retval.put(CONTEXT_COLUMN_LABEL, maxContextLen);
        retval.put(ROUTE_COLUMN_LABEL, maxRouteLen);
        retval.put(STATUS_COLUMN_LABEL, maxStatusLen);
        return retval;
    }

    private static String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        int contextLen = Math.min(columnWidths.get(CONTEXT_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int routeLen = Math.min(columnWidths.get(ROUTE_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int statusLen = Math.min(columnWidths.get(STATUS_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        contextLen = Math.max(12, contextLen);
        routeLen = Math.max(12, routeLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(contextLen).append('.').append(contextLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(routeLen).append('.').append(routeLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(statusLen).append('.').append(statusLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }
}

