/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.dominion.controller.internal;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.minion.api.MinionInitializationMessage;
import org.opennms.minion.dominion.controller.internal.DominionControllerImpl;

final class MinionQueueNameProcessor
implements Processor {
    MinionQueueNameProcessor() {
    }

    public void process(Exchange e) {
        Object o = e.getIn().getBody();
        if (o instanceof MinionInitializationMessage) {
            MinionInitializationMessage message = (MinionInitializationMessage)o;
            String minionId = message.getMinionId();
            if (minionId == null || minionId.trim().isEmpty()) {
                return;
            }
            DominionControllerImpl.LOG.debug("Setting header to control-{}", (Object)minionId);
            e.getIn().setHeader("CamelJmsDestinationName", (Object)("control-" + minionId));
        }
    }
}

