/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.dominion.controller.internal;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.jaxb.JaxbDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.opennms.minion.api.MinionException;
import org.opennms.minion.api.MinionInitializationMessage;
import org.opennms.minion.api.MinionMessage;
import org.opennms.minion.api.MinionMessageReceiver;
import org.opennms.minion.api.MinionMessageSender;
import org.opennms.minion.api.MinionStatusMessage;
import org.opennms.minion.api.StatusMessageWriter;
import org.opennms.minion.dominion.controller.internal.MinionQueueNameProcessor;
import org.opennms.minion.impl.MinionInitializationMessageImpl;
import org.opennms.minion.impl.MinionStatusMessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DominionControllerImpl
implements MinionMessageReceiver {
    static final Logger LOG = LoggerFactory.getLogger(DominionControllerImpl.class);
    private String m_brokerUri;
    private String m_listenQueueName;
    private CamelContext m_camelContext;
    private ProducerTemplate m_producer;
    private StatusMessageWriter m_statusMessageWriter;
    private MinionMessageReceiver m_messageReceiver;
    private MinionMessageSender m_messageSender;
    boolean m_camelContextInitialized = false;

    public void start() throws MinionException {
        LOG.info("DominionController starting.");
        assert (this.m_brokerUri != null) : "You must specify the broker URI!";
        assert (this.m_listenQueueName != null) : "You must specify the queue to listen on for initialization messages!";
        assert (this.m_statusMessageWriter != null) : "You must pass a StatusMessageWriter to the dominion controller!";
        this.assertCamelContextInitialized();
    }

    public void stop() throws MinionException {
        LOG.info("DominionController shutting down.");
    }

    public void onMessage(MinionMessage message) throws MinionException {
        if (!(message instanceof MinionStatusMessage)) {
            throw new MinionException("Unknown message type " + message.getClass().getName() + ": " + message);
        }
        LOG.debug("got status message: {}", (Object)message);
        MinionStatusMessage statusMessage = (MinionStatusMessage)message;
        this.m_statusMessageWriter.write(statusMessage.getId(), statusMessage.getLocation(), statusMessage.getStatus(), statusMessage.getDate(), statusMessage.getProperties());
        MinionInitializationMessageImpl initMessage = new MinionInitializationMessageImpl(statusMessage.getId(), Integer.valueOf(1));
        initMessage.addFeatureRepository("mvn:org.opennms.netmgt.sample/karaf/16.0.0-PJSM-SNAPSHOT/xml/minion");
        initMessage.addFeatureRepository("mvn:org.opennms.netmgt.sample/karaf/16.0.0-PJSM-SNAPSHOT/xml");
        this.sendInitializationMessage((MinionInitializationMessage)initMessage);
    }

    protected void sendInitializationMessage(MinionInitializationMessage message) throws MinionException {
        this.assertMessageSenderExists();
        LOG.info("Sending initialization message: {}", (Object)message);
        this.m_messageSender.sendMessage((MinionMessage)message);
    }

    protected void assertMessageSenderExists() throws MinionException {
        if (this.m_messageSender == null) {
            assert (this.m_camelContext != null) : "Can't create a message sender without a camel context!";
            this.m_producer = this.m_camelContext.createProducerTemplate();
            this.m_messageSender = new MinionMessageSender(){

                public void sendMessage(MinionMessage message) throws MinionException {
                    DominionControllerImpl.this.m_producer.asyncRequestBody("seda:sendMessage", (Object)message);
                }
            };
        }
    }

    protected void assertCamelContextInitialized() throws MinionException {
        JaxbDataFormat df;
        if (this.m_camelContextInitialized) {
            return;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MinionStatusMessageImpl.class, MinionInitializationMessageImpl.class});
            df = new JaxbDataFormat(context);
        }
        catch (JAXBException e) {
            String errorMessage = "Failed to create JAXB context for the minion controller!";
            LOG.error("Failed to create JAXB context for the minion controller!", (Throwable)e);
            throw new MinionException("Failed to create JAXB context for the minion controller!", (Throwable)e);
        }
        final MinionQueueNameProcessor queueProcessor = new MinionQueueNameProcessor();
        try {
            if (this.m_camelContext instanceof DefaultCamelContext) {
                DefaultCamelContext defaultCamelContext = (DefaultCamelContext)this.m_camelContext;
                int waitfor = 30;
                while (!defaultCamelContext.isStarted() && waitfor-- > 0) {
                    LOG.debug("Waiting for camel context to start...");
                    Thread.sleep(1000L);
                }
            }
            ActiveMQComponent activemq = new ActiveMQComponent();
            activemq.setBrokerURL(this.m_brokerUri);
            this.m_camelContext.addComponent("activemq", (Component)activemq);
            this.m_camelContext.addRoutes((RoutesBuilder)new RouteBuilder((DataFormat)df){
                final /* synthetic */ DataFormat val$df;
                {
                    this.val$df = dataFormat;
                }

                public void configure() throws Exception {
                    ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:sendMessage").routeId("sendMinionMessage").shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).log(LoggingLevel.DEBUG, "dominion-controller: sendMinionMessage: ${body.toString()}")).process(queueProcessor)).marshal(this.val$df)).to("activemq:dummy?disableReplyTo=true");
                    DominionControllerImpl.this.assertMessageReaderExists();
                    ((RouteDefinition)((RouteDefinition)this.from("activemq:initialization").routeId("receiveMinionMessage").shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).log(LoggingLevel.DEBUG, "dominion-controller: receiveMinionMessage: ${body}")).unmarshal(this.val$df)).bean((Object)DominionControllerImpl.this.m_messageReceiver, "onMessage");
                }
            });
            this.m_camelContextInitialized = true;
            LOG.info("Finished initializing Camel context.");
        }
        catch (Exception e) {
            throw new MinionException("Failed to configure routes for minion-controller context!", (Throwable)e);
        }
    }

    private void assertMessageReaderExists() throws MinionException {
        if (this.m_messageReceiver == null) {
            this.m_messageReceiver = this;
        }
    }

    public void setBrokerUri(String brokerUri) {
        this.m_brokerUri = brokerUri;
    }

    public void setListenQueueName(String queueName) {
        this.m_listenQueueName = queueName;
    }

    public void setStatusMessageWriter(StatusMessageWriter writer) {
        this.m_statusMessageWriter = writer;
    }

    public void setMessageSender(MinionMessageSender sender) {
        this.m_messageSender = sender;
    }

    public void setMessageReceiver(MinionMessageReceiver receiver) {
        this.m_messageReceiver = receiver;
    }

    public void setCamelContext(CamelContext context) {
        this.m_camelContext = context;
    }
}

