/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.api.sample.Sample;
import org.opennms.netmgt.api.sample.SampleValue;
import org.opennms.netmgt.api.sample.Timestamp;

@XmlRootElement(name="sample-set")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SampleSet
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="timestamp")
    private final Timestamp m_timestamp;
    @XmlElementWrapper(name="samples")
    @XmlElement(name="sample")
    private final List<Sample> m_measurements = new LinkedList<Sample>();
    private transient Map<Resource, Map<String, LinkedList<Sample>>> m_byResourceGroup;
    private transient Map<Resource, LinkedList<Sample>> m_byResource;
    private transient Map<String, LinkedList<Sample>> m_byGroup;
    private boolean m_dirtyByResourceGroup = false;
    private boolean m_dirtyByResource = false;
    private boolean m_dirtyByGroup = false;

    public SampleSet() {
        this.m_timestamp = Timestamp.now();
    }

    public SampleSet(Timestamp timestamp) {
        this.m_timestamp = timestamp;
    }

    public void addMeasurement(Resource r, Metric m, SampleValue<?> value) {
        Sample sample = new Sample(r, m, this.m_timestamp, value);
        this.setDirty();
        this.m_measurements.add(sample);
    }

    private void setDirty() {
        this.m_dirtyByResourceGroup = true;
        this.m_dirtyByResource = true;
        this.m_dirtyByGroup = true;
    }

    private void validateByResourceGroup() {
        if (this.m_byResourceGroup == null) {
            this.m_byResourceGroup = new HashMap<Resource, Map<String, LinkedList<Sample>>>();
            this.m_dirtyByResourceGroup = true;
        }
    }

    private void validateByResource() {
        if (this.m_byResource == null) {
            this.m_byResource = new HashMap<Resource, LinkedList<Sample>>();
            this.m_dirtyByResource = true;
        }
    }

    private void validateByGroup() {
        if (this.m_byGroup == null) {
            this.m_byGroup = new HashMap<String, LinkedList<Sample>>();
            this.m_dirtyByGroup = true;
        }
    }

    private void indexByResourceGroup() {
        this.validateByResourceGroup();
        if (this.m_dirtyByResourceGroup) {
            for (Sample sample : this.m_measurements) {
                Resource r = sample.getResource();
                String group = sample.getMetric().getGroup();
                if (!this.m_byResourceGroup.containsKey(r)) {
                    this.m_byResourceGroup.put(r, new HashMap());
                }
                if (!this.m_byResourceGroup.get(r).containsKey(group)) {
                    this.m_byResourceGroup.get(r).put(group, new LinkedList());
                }
                this.m_byResourceGroup.get(r).get(group).add(sample);
            }
            this.m_dirtyByResourceGroup = false;
        }
    }

    private void indexByResource() {
        this.validateByResource();
        if (this.m_dirtyByResource) {
            for (Sample sample : this.m_measurements) {
                Resource r = sample.getResource();
                if (!this.m_byResource.containsKey(r)) {
                    this.m_byResource.put(r, new LinkedList());
                }
                this.m_byResource.get(r).add(sample);
            }
            this.m_dirtyByResource = false;
        }
    }

    private void indexByGroup() {
        this.validateByGroup();
        if (this.m_dirtyByGroup) {
            for (Sample sample : this.m_measurements) {
                String group = sample.getMetric().getGroup();
                if (!this.m_byGroup.containsKey(group)) {
                    this.m_byGroup.put(group, new LinkedList());
                }
                this.m_byGroup.get(group).add(sample);
            }
            this.m_dirtyByGroup = false;
        }
    }

    public Set<Resource> getResources() {
        this.indexByResourceGroup();
        return this.m_byResourceGroup.keySet();
    }

    public Timestamp getTimestamp() {
        return this.m_timestamp;
    }

    public Date getTimestampAsDate() {
        return this.m_timestamp.asDate();
    }

    public Set<String> getGroups() {
        this.indexByGroup();
        return this.m_byGroup.keySet();
    }

    public Set<String> getGroups(Resource resource) {
        this.indexByResourceGroup();
        return this.m_byResourceGroup.containsKey(resource) ? this.m_byResourceGroup.get(resource).keySet() : null;
    }

    public Collection<Sample> getSamplesForGroup(String groupName) {
        this.indexByGroup();
        return this.m_byGroup.get(groupName);
    }

    public Collection<Sample> getSamplesForResource(Resource resource) {
        this.indexByResource();
        return this.m_byResource.get(resource);
    }

    public Collection<Sample> getSamplesForResourceAndGroup(Resource resource, String groupName) {
        this.indexByResourceGroup();
        return this.m_byResourceGroup.containsKey(resource) ? this.m_byResourceGroup.get(resource).get(groupName) : null;
    }

    public Collection<Sample> getMeasurements() {
        return this.m_measurements;
    }

    public Collection<Sample> getSamples() {
        return this.m_measurements;
    }

    public String toString() {
        return "SampleSet" + this.getSamples();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_measurements == null ? 0 : this.m_measurements.hashCode());
        result = 31 * result + (this.m_timestamp == null ? 0 : this.m_timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampleSet)) {
            return false;
        }
        SampleSet other = (SampleSet)obj;
        if (this.m_measurements == null ? other.m_measurements != null : !this.m_measurements.equals(other.m_measurements)) {
            return false;
        }
        return !(this.m_timestamp == null ? other.m_timestamp != null : !this.m_timestamp.equals(other.m_timestamp));
    }
}

