/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.util.Collection;
import java.util.Iterator;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.NanValue;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.api.sample.Results;
import org.opennms.netmgt.api.sample.Sample;

public abstract class SampleProcessor
implements Iterator<Results.Row> {
    private SampleProcessor m_producer;

    public void setProducer(SampleProcessor producer) {
        this.m_producer = producer;
    }

    public SampleProcessor getProducer() {
        return this.m_producer;
    }

    public Collection<Metric> getMetrics() {
        return this.getProducer() != null ? this.getProducer().getMetrics() : null;
    }

    public Resource getResource() {
        return this.getProducer() != null ? this.getProducer().getResource() : this.getResource();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator<Row>.remove is not yet implemented.");
    }

    protected Results.Row fillMissingSamples(Results.Row row) {
        if (this.getMetrics() != null) {
            for (Metric metric : this.getMetrics()) {
                if (row.containsSample(metric)) continue;
                row.addSample(new Sample(row.getResource(), metric, row.getTimestamp(), new NanValue()));
            }
        }
        return row;
    }
}

