/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.api.sample.AbsoluteValue;
import org.opennms.netmgt.api.sample.CounterValue;
import org.opennms.netmgt.api.sample.DeriveValue;
import org.opennms.netmgt.api.sample.GaugeValue;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.NanValue;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.api.sample.SampleValue;
import org.opennms.netmgt.api.sample.SampleValueAdapter;
import org.opennms.netmgt.api.sample.Timestamp;

@XmlRootElement(name="sample")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlSeeAlso(value={AbsoluteValue.class, CounterValue.class, DeriveValue.class, GaugeValue.class, NanValue.class})
public class Sample
implements Comparable<Sample>,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="resource")
    private final Resource m_resource;
    @XmlElement(name="metric")
    private final Metric m_metric;
    @XmlElement(name="timestamp")
    private final Timestamp m_timestamp;
    @XmlElement(name="sample-value")
    @XmlJavaTypeAdapter(value=SampleValueAdapter.class)
    private final SampleValue<?> m_value;

    public Sample() {
        this.m_resource = null;
        this.m_metric = null;
        this.m_timestamp = null;
        this.m_value = null;
    }

    public Sample(Resource resource, Metric metric, Timestamp timestamp, SampleValue<?> value) {
        this.m_resource = resource;
        this.m_metric = metric;
        this.m_timestamp = timestamp;
        this.m_value = value;
    }

    public Resource getResource() {
        return this.m_resource;
    }

    public Metric getMetric() {
        return this.m_metric;
    }

    public Timestamp getTimestamp() {
        return this.m_timestamp;
    }

    public SampleValue<?> getValue() {
        return this.m_value;
    }

    @Override
    public int compareTo(Sample o) {
        return this.getTimestamp().compareTo(o.getTimestamp());
    }

    public String toString() {
        return String.format("%s %s:%s=%s", this.m_timestamp, this.m_resource.getIdentifier(), this.m_metric.getName(), this.m_value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_metric == null ? 0 : this.m_metric.hashCode());
        result = 31 * result + (this.m_resource == null ? 0 : this.m_resource.hashCode());
        result = 31 * result + (this.m_timestamp == null ? 0 : this.m_timestamp.hashCode());
        result = 31 * result + (this.m_value == null ? 0 : this.m_value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)obj;
        if (this.m_metric == null ? other.m_metric != null : !this.m_metric.equals(other.m_metric)) {
            return false;
        }
        if (this.m_resource == null ? other.m_resource != null : !this.m_resource.equals(other.m_resource)) {
            return false;
        }
        if (this.m_timestamp == null ? other.m_timestamp != null : !this.m_timestamp.equals(other.m_timestamp)) {
            return false;
        }
        return !(this.m_value == null ? other.m_value != null : !this.m_value.equals(other.m_value));
    }
}

