/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.api.sample.Agent;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Service;

public class PackageAgentList {
    private final Package m_package;
    private final List<Agent> m_agents = new ArrayList<Agent>();

    public PackageAgentList(Package packageService, List<Agent> agents) {
        this.m_package = packageService;
        if (agents != null) {
            this.m_agents.addAll(agents);
        }
    }

    public Package getPackage() {
        return this.m_package;
    }

    public List<Agent> getAgents() {
        return this.m_agents;
    }

    public Long getInterval() {
        return ((Service)this.m_package.getServices().get(0)).getInterval();
    }

    public String getServiceName() {
        return ((Service)this.m_package.getServices().get(0)).getName();
    }

    public String getId() {
        return this.getPackage().getName() + "/" + this.getServiceName();
    }

    public String toString() {
        return "PackageAgentList [package=" + this.m_package + ", agents=" + this.m_agents + "]";
    }
}

