/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.IPAddress;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="agent")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Agent
implements Serializable {
    private static final long serialVersionUID = 5L;
    private static final Logger LOG = LoggerFactory.getLogger(Agent.class);
    @XmlElement(name="address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private final InetAddress m_agentAddress;
    @XmlElement(name="port")
    private final Integer m_port;
    @XmlElement(name="serviceName")
    private final String m_serviceName;
    @XmlElement(name="id")
    private final String m_agentId;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    protected final Map<String, String> m_parameters = new HashMap<String, String>();

    public Agent() {
        this.m_serviceName = null;
        this.m_agentAddress = null;
        this.m_port = null;
        this.m_agentId = null;
    }

    public Agent(InetSocketAddress agentAddress, String serviceName, String agentId) {
        this.m_agentAddress = agentAddress.getAddress();
        this.m_port = agentAddress.getPort();
        this.m_serviceName = serviceName;
        this.m_agentId = agentId == null ? this.getFauxId() : agentId;
    }

    public Agent(Agent agent) {
        this(new InetSocketAddress(agent.getInetAddress(), agent.getPort()), agent.getServiceName(), agent.getId());
        this.m_parameters.putAll(agent.getParameters());
    }

    @Deprecated
    public Agent(InetSocketAddress agentAddress, String serviceName) {
        this(agentAddress, serviceName, null);
    }

    @Deprecated
    public Agent(InetAddress addr, int port, String serviceName) {
        this.m_agentAddress = addr;
        this.m_port = port;
        this.m_serviceName = serviceName;
        this.m_agentId = this.getFauxId();
    }

    public Agent(IPAddress ipAddress, int port, String serviceName) {
        this(new InetSocketAddress(ipAddress.toInetAddress(), port), serviceName, null);
    }

    public Agent(IPAddress ipAddress, int port, String serviceName, String agentId) {
        this(new InetSocketAddress(ipAddress.toInetAddress(), port), serviceName, agentId);
    }

    public String getId() {
        if (this.m_agentId == null) {
            return this.getFauxId();
        }
        return this.m_agentId;
    }

    public InetSocketAddress getAgentAddress() {
        return new InetSocketAddress(this.m_agentAddress, (int)this.m_port);
    }

    public InetAddress getInetAddress() {
        return this.m_agentAddress;
    }

    public Integer getNodeId() {
        String nodeId;
        if (this.m_parameters != null && this.m_parameters.containsKey("nodeId") && (nodeId = this.m_parameters.get("nodeId")) != null && !nodeId.trim().isEmpty()) {
            try {
                return Integer.valueOf(nodeId);
            }
            catch (NumberFormatException e) {
                LOG.warn("Node ID ({}) exists, but is not a number!", (Object)nodeId);
            }
        }
        return null;
    }

    public String getForeignSource() {
        if (this.m_parameters != null && this.m_parameters.containsKey("foreignSource") && !this.m_parameters.get("foreignSource").trim().isEmpty()) {
            return this.m_parameters.get("foreignSource");
        }
        return null;
    }

    public String getForeignId() {
        if (this.m_parameters != null && this.m_parameters.containsKey("foreignId") && !this.m_parameters.get("foreignId").trim().isEmpty()) {
            return this.m_parameters.get("foreignId");
        }
        return null;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.m_parameters);
    }

    public String getParameter(String key) {
        return this.m_parameters.get(key);
    }

    public void setParameter(String key, String value) {
        this.m_parameters.put(key, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.m_agentId + ", address=" + this.m_agentAddress + ", port=" + this.m_port + ", serviceName=" + this.m_serviceName + ", parameters=" + this.m_parameters + "]";
    }

    private String getFauxId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_serviceName).append(":");
        if (this.m_agentAddress != null) {
            sb.append(this.m_agentAddress.getHostAddress());
        } else {
            sb.append("null");
        }
        sb.append(":").append(this.m_port);
        return sb.toString();
    }
}

