/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.aggregate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.Gauge;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.ValueType;

class Rate
implements Iterator<Results.Row<Sample>>,
Iterable<Results.Row<Sample>> {
    private static final Gauge NAN = new Gauge(Double.NaN);
    private final Iterator<Results.Row<Sample>> m_input;
    private final Set<String> m_metrics;
    private final Map<String, Sample> m_prevSamples = Maps.newHashMap();

    Rate(Iterator<Results.Row<Sample>> input, Set<String> metrics) {
        this.m_input = (Iterator)Preconditions.checkNotNull(input, (Object)"input argument");
        this.m_metrics = (Set)Preconditions.checkNotNull(metrics, (Object)"metrics argument");
    }

    @Override
    public boolean hasNext() {
        return this.m_input.hasNext();
    }

    @Override
    public Results.Row<Sample> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Results.Row<Sample> working = this.m_input.next();
        Results.Row result = new Results.Row(working.getTimestamp(), working.getResource());
        for (String metricName : this.m_metrics) {
            Sample sample = (Sample)working.getElement(metricName);
            if (sample == null) continue;
            result.addElement((Element)(sample.getType().equals((Object)MetricType.COUNTER) ? this.getRate(sample) : sample));
            this.m_prevSamples.put(sample.getName(), sample);
        }
        return result;
    }

    private Sample getRate(Sample sample) {
        Gauge value = NAN;
        Sample previous = this.m_prevSamples.get(sample.getName());
        if (previous != null) {
            long elapsed = sample.getTimestamp().asSeconds() - previous.getTimestamp().asSeconds();
            value = sample.getValue().delta((Number)previous.getValue()).divideBy((Number)elapsed);
        }
        return new Sample(sample.getTimestamp(), sample.getResource(), sample.getName(), MetricType.GAUGE, (ValueType)value);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Results.Row<Sample>> iterator() {
        return this;
    }
}

