/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.RegistrationHook;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsOSGiBridgeActivator
implements RegistrationHook,
ServiceListener,
BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsOSGiBridgeActivator.class);
    private final AtomicReference<BundleContext> m_bundleContext = new AtomicReference();
    private static final String ONMS_SOURCE = "onms";
    private static final String OSGI_SOURCE = "osgi";
    private static final String REGISTRATION_EXPORT = "registration.export";
    private static final String REGISTRATION_SOURCE = "registration.source";
    private final ServiceRegistry m_registry = DefaultServiceRegistry.INSTANCE;
    private final Map<Registration, ServiceRegistration<?>> m_onmsRegistration2osgiRegistrationMap = new ConcurrentHashMap();
    private final Map<ServiceReference<?>, Registration> m_osgiReference2onmsRegistrationMap = new ConcurrentHashMap();

    public void start(BundleContext bundleContext) throws InvalidSyntaxException {
        LOG.debug("Starting BundleActivator {}", (Object)this.toString());
        this.m_bundleContext.set(bundleContext);
        this.getRegistry().addRegistrationHook(this, true);
        String exportFilter = "(registration.export=*)";
        bundleContext.addServiceListener((ServiceListener)this, exportFilter);
        ServiceReference[] osgiServices = bundleContext.getAllServiceReferences(null, exportFilter);
        if (osgiServices != null) {
            for (ServiceReference reference : osgiServices) {
                this.registerWithOnmsRegistry(reference);
            }
        }
        LOG.debug("BundleActivator {} started", (Object)this.toString());
    }

    public void stop(BundleContext bundleContext) {
        this.m_bundleContext.set(null);
    }

    @Override
    public void registrationAdded(Registration onmsRegistration) {
        Map<Object, Object> onmsProperties;
        Map<Object, Object> map = onmsProperties = onmsRegistration.getProperties() == null ? Collections.emptyMap() : onmsRegistration.getProperties();
        if (OSGI_SOURCE.equals(onmsProperties.get(REGISTRATION_SOURCE))) {
            return;
        }
        Class<?>[] providerInterfaces = onmsRegistration.getProvidedInterfaces();
        String[] serviceClasses = new String[providerInterfaces.length];
        for (int i = 0; i < providerInterfaces.length; ++i) {
            serviceClasses[i] = providerInterfaces[i].getName();
        }
        Hashtable<Object, Object> props = new Hashtable<Object, Object>();
        for (Map.Entry<Object, Object> entry : onmsProperties.entrySet()) {
            ((Dictionary)props).put(entry.getKey(), entry.getValue());
        }
        ((Dictionary)props).put(REGISTRATION_SOURCE, ONMS_SOURCE);
        BundleContext bundleContext = this.m_bundleContext.get();
        if (bundleContext != null) {
            ServiceRegistration osgiRegistration = bundleContext.registerService(serviceClasses, onmsRegistration.getProvider(), props);
            this.m_onmsRegistration2osgiRegistrationMap.put(onmsRegistration, osgiRegistration);
        }
    }

    @Override
    public void registrationRemoved(Registration onmsRegistration) {
        ServiceRegistration<?> osgiRegistration = this.m_onmsRegistration2osgiRegistrationMap.remove(onmsRegistration);
        if (osgiRegistration == null) {
            return;
        }
        osgiRegistration.unregister();
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        switch (serviceEvent.getType()) {
            case 1: {
                this.registerWithOnmsRegistry(serviceEvent.getServiceReference());
                break;
            }
            case 2: {
                this.registerWithOnmsRegistry(serviceEvent.getServiceReference());
                break;
            }
            case 8: {
                this.unregisterWithOnmsRegistry(serviceEvent.getServiceReference());
                break;
            }
            case 4: {
                this.unregisterWithOnmsRegistry(serviceEvent.getServiceReference());
            }
        }
    }

    private void registerWithOnmsRegistry(ServiceReference<?> reference) {
        LOG.debug("registerWithOnmsRegistry: {}", (Object)reference.getBundle());
        BundleContext bundleContext = this.m_bundleContext.get();
        if (bundleContext == null) {
            LOG.warn("No BundleContext found, skipping registration of services: {}", reference);
            return;
        }
        if (!this.isOnmsExported(reference)) {
            return;
        }
        if (this.isOnmsSource(reference)) {
            return;
        }
        if (this.m_osgiReference2onmsRegistrationMap.containsKey(reference)) {
            return;
        }
        String[] classNames = (String[])reference.getProperty("objectClass");
        try {
            Object[] providerInterfaces = this.findClasses(classNames);
            Object provider = bundleContext.getService(reference);
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            for (String key : reference.getPropertyKeys()) {
                Object val = reference.getProperty(key);
                StringBuilder buf = new StringBuilder();
                if (val instanceof Object[]) {
                    Object[] a = (Object[])val;
                    for (int i = 0; i < a.length; ++i) {
                        if (i != 0) {
                            buf.append(',');
                        }
                        buf.append(a[i]);
                    }
                } else {
                    buf.append(val);
                }
                properties.put(key, buf.toString());
            }
            properties.put(REGISTRATION_SOURCE, OSGI_SOURCE);
            LOG.debug("OnmsOSGiBridgeActivator: registering...");
            Registration onmsRegistration = this.getRegistry().register(provider, (Map<String, String>)properties, (Class<?>[])providerInterfaces);
            LOG.debug("OnmsOSGiBridgeActivator: registry = {}", (Object)this.getRegistry());
            this.m_osgiReference2onmsRegistrationMap.put(reference, onmsRegistration);
            LOG.info("OnmsOSGiBridgeActivator: registered provider {} for interfaces: {} with properties: {}", new Object[]{provider, Arrays.toString(providerInterfaces), properties});
        }
        catch (ClassNotFoundException e) {
            LOG.warn("OnmsOSGiBridgeActivator: Unable to find class used by exported OSGi service", (Throwable)e);
        }
    }

    private boolean isOnmsExported(ServiceReference<?> reference) {
        return Arrays.asList(reference.getPropertyKeys()).contains(REGISTRATION_EXPORT);
    }

    private boolean isOnmsSource(ServiceReference<?> reference) {
        return ONMS_SOURCE.equals(reference.getProperty(REGISTRATION_SOURCE));
    }

    private Class<?>[] findClasses(String[] classNames) throws ClassNotFoundException {
        Class[] providerInterfaces = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            providerInterfaces[i] = Class.forName(classNames[i]);
        }
        return providerInterfaces;
    }

    private void unregisterWithOnmsRegistry(ServiceReference<?> reference) {
        Registration onmsRegistration = this.m_osgiReference2onmsRegistrationMap.remove(reference);
        if (onmsRegistration == null) {
            return;
        }
        onmsRegistration.unregister();
    }

    private ServiceRegistry getRegistry() {
        return this.m_registry;
    }
}

