/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Service;

@XmlRootElement(name="collectd-configuration")
@ValidateUsing(value="collectd-configuration.xsd")
@XmlAccessorType(value=XmlAccessType.NONE)
public class CollectdConfiguration
implements Serializable {
    private static final long serialVersionUID = -5767101206283939127L;
    @XmlAttribute(name="threads")
    private Integer m_threads;
    @XmlElement(name="package")
    private List<Package> m_packages = new ArrayList<Package>();
    @XmlElement(name="collector")
    private List<Collector> m_collectors = new ArrayList<Collector>();

    public Integer getThreads() {
        return this.m_threads == null ? 0 : this.m_threads;
    }

    public void setThreads(Integer threads) {
        this.m_threads = threads;
    }

    public List<Package> getPackages() {
        if (this.m_packages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_packages);
    }

    public void setPackages(List<Package> packages) {
        this.m_packages = new ArrayList<Package>(packages);
    }

    public void addPackage(Package p) throws IndexOutOfBoundsException {
        this.m_packages.add(p);
    }

    public boolean removePackage(Package p) {
        return this.m_packages.remove(p);
    }

    public Package getPackage(String packageName) {
        for (Package pkg : this.m_packages) {
            if (!pkg.getName().equals(packageName)) continue;
            return pkg;
        }
        return null;
    }

    public List<Collector> getCollectors() {
        if (this.m_collectors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_collectors);
    }

    public void setCollectors(List<Collector> collectors) {
        this.m_collectors = new ArrayList<Collector>(collectors);
    }

    public void addCollector(Collector collector) throws IndexOutOfBoundsException {
        this.m_collectors.add(collector);
    }

    public void addCollector(String service, String className) {
        this.m_collectors.add(new Collector(service, className));
    }

    public boolean removeCollector(Collector collector) {
        return this.m_collectors.remove(collector);
    }

    public Filter getFilter(String filterName) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Package p : this.getPackages()) {
            Filter filter = p.getFilter();
            if (filterName.equals(filter.getName())) {
                filters.add(filter);
                continue;
            }
            if (!filterName.equals(p.getName())) continue;
            filter.setName(p.getName());
            filters.add(filter);
        }
        if (filters.size() > 1) {
            throw new IllegalArgumentException("Filter name " + filterName + " matched more than one filter in collectd-configuration.xml!");
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return null;
    }

    public CollectdConfiguration getCollectdConfigurationForPackage(String collectionPackageName) {
        if (collectionPackageName == null) {
            return null;
        }
        Package pkg = this.getPackage(collectionPackageName);
        if (pkg == null) {
            return null;
        }
        HashSet<String> seenCollectors = new HashSet<String>();
        CollectdConfiguration newConfig = new CollectdConfiguration();
        newConfig.setThreads(this.getThreads());
        newConfig.addPackage(pkg);
        for (Service service : pkg.getServices()) {
            seenCollectors.add(service.getName());
        }
        for (Collector collector : this.getCollectors()) {
            if (!seenCollectors.contains(collector.getService())) continue;
            newConfig.addCollector(collector);
        }
        return newConfig;
    }

    public int hashCode() {
        int prime = 631;
        int result = 1;
        result = 631 * result + (this.m_collectors == null ? 0 : this.m_collectors.hashCode());
        result = 631 * result + (this.m_packages == null ? 0 : this.m_packages.hashCode());
        result = 631 * result + (this.m_threads == null ? 0 : this.m_threads.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectdConfiguration)) {
            return false;
        }
        CollectdConfiguration other = (CollectdConfiguration)obj;
        if (this.m_collectors == null ? other.m_collectors != null : !this.m_collectors.equals(other.m_collectors)) {
            return false;
        }
        if (this.m_packages == null ? other.m_packages != null : !this.m_packages.equals(other.m_packages)) {
            return false;
        }
        return !(this.m_threads == null ? other.m_threads != null : !this.m_threads.equals(other.m_threads));
    }

    public String toString() {
        return "CollectdConfiguration [threads=" + this.m_threads + ", packages=" + this.m_packages + ", collectors=" + this.m_collectors + "]";
    }
}

