/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.controller.internal;

import java.io.IOException;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.jaxb.JaxbDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.karaf.admin.AdminService;
import org.apache.karaf.admin.Instance;
import org.opennms.minion.api.MinionController;
import org.opennms.minion.api.MinionException;
import org.opennms.minion.api.MinionMessage;
import org.opennms.minion.api.MinionMessageReceiver;
import org.opennms.minion.api.MinionMessageSender;
import org.opennms.minion.api.MinionStatusMessage;
import org.opennms.minion.impl.MinionInitializationMessageImpl;
import org.opennms.minion.impl.MinionStatusMessageImpl;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinionControllerImpl
implements MinionController,
MinionMessageReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(MinionControllerImpl.class);
    private AdminService m_adminService;
    private ConfigurationAdmin m_configurationAdmin;
    private String m_brokerUri;
    private String m_sendQueueName;
    private String m_id;
    private String m_location;
    private CamelContext m_camelContext;
    private ProducerTemplate m_producer;
    private MinionMessageSender m_messageSender;
    private MinionMessageReceiver m_messageReceiver;
    private boolean m_camelContextInitialized = false;

    public void start() throws MinionException {
        String location;
        LOG.info("Initializing MinionController.");
        assert (this.m_adminService != null) : "AdminService is missing!";
        assert (this.m_configurationAdmin != null) : "ConfigurationAdmin is missing!";
        assert (this.m_brokerUri != null) : "Broker URI is missing!";
        assert (this.m_sendQueueName != null) : "Sending queue name is missing!";
        this.m_id = this.loadProperty("id");
        if (this.m_id == null) {
            this.m_id = UUID.randomUUID().toString();
            this.saveProperty("id", this.m_id);
        }
        if ((location = (this.m_location = this.loadProperty("location"))) == null) {
            throw new MinionException("Location is not set!  Please make sure you set location='Location Name' in the org.opennms.minion.controller configuration.");
        }
        this.assertCamelContextInitialized();
        this.sendStartMessage();
        LOG.info("MinionController initialized. ID is {}.", (Object)this.m_id);
    }

    public void stop() throws MinionException {
        LOG.info("MinionController shutting down.");
        this.sendStopMessage();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public void sendStartMessage() throws MinionException {
        this.assertMessageSenderExists();
        this.m_messageSender.sendMessage((MinionMessage)this.createStatusMessage("Started"));
    }

    public void sendStopMessage() throws MinionException {
        this.assertMessageSenderExists();
        this.m_messageSender.sendMessage((MinionMessage)this.createStatusMessage("Stopped"));
    }

    protected void assertMessageSenderExists() throws MinionException {
        if (this.m_messageSender == null) {
            assert (this.m_camelContext != null) : "Can't create a message sender without a camel context!";
            this.m_producer = this.m_camelContext.createProducerTemplate();
            this.m_messageSender = new MinionMessageSender(){

                public void sendMessage(MinionMessage message) throws MinionException {
                    MinionControllerImpl.this.m_producer.asyncRequestBody("seda:sendMessage", (Object)message);
                }
            };
        }
    }

    public String getId() throws MinionException {
        return this.m_id;
    }

    public String getLocation() throws MinionException {
        return this.m_location;
    }

    public void onMessage(MinionMessage message) throws MinionException {
        LOG.debug("Got minion message: {}", (Object)message);
    }

    protected void assertMessageReceiverExists() {
        if (this.m_messageReceiver == null) {
            this.m_messageReceiver = this;
        }
    }

    protected void assertCamelContextInitialized() throws MinionException {
        JaxbDataFormat df;
        if (this.m_camelContextInitialized) {
            LOG.trace("Camel context already initialized!");
            return;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MinionStatusMessageImpl.class, MinionInitializationMessageImpl.class});
            df = new JaxbDataFormat(context);
        }
        catch (JAXBException e) {
            String errorMessage = "Failed to create JAXB context for the minion controller!";
            LOG.error("Failed to create JAXB context for the minion controller!", (Throwable)e);
            throw new MinionException("Failed to create JAXB context for the minion controller!", (Throwable)e);
        }
        try {
            if (this.m_camelContext instanceof DefaultCamelContext) {
                DefaultCamelContext defaultCamelContext = (DefaultCamelContext)this.m_camelContext;
                int waitfor = 30;
                while (!defaultCamelContext.isStarted() && waitfor-- > 0) {
                    LOG.debug("Waiting for camel context to start...");
                    Thread.sleep(1000L);
                }
            }
            this.m_camelContext.addRoutes((RoutesBuilder)new RouteBuilder((DataFormat)df){
                final /* synthetic */ DataFormat val$df;
                {
                    this.val$df = dataFormat;
                }

                public void configure() throws Exception {
                    ((RouteDefinition)((RouteDefinition)this.from("seda:sendMessage").routeId("sendMinionMessage").shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).log(LoggingLevel.DEBUG, "minion-controller: sendMinionMessage: ${body.toString()}")).marshal(this.val$df)).to("amq:queue:" + MinionControllerImpl.this.m_sendQueueName + "?disableReplyTo=true");
                    MinionControllerImpl.this.assertMessageReceiverExists();
                    ((RouteDefinition)((RouteDefinition)this.from("amq:queue:control-" + MinionControllerImpl.this.m_id).routeId("receiveMinionMessage").shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).log(LoggingLevel.DEBUG, "minion-controller: receiveMinionMessage: ${body}")).unmarshal(this.val$df)).bean((Object)MinionControllerImpl.this.m_messageReceiver, "onMessage");
                }
            });
            LOG.info("Finished initializing Camel context.");
            this.m_camelContextInitialized = true;
        }
        catch (Exception e) {
            throw new MinionException("Failed to configure routes for minion-controller context!", (Throwable)e);
        }
    }

    public MinionStatusMessage createStatusMessage(String withStatus) throws MinionException {
        MinionStatusMessageImpl minionStatus = new MinionStatusMessageImpl(this.m_id, Integer.valueOf(1));
        String status = withStatus;
        if (withStatus == null) {
            Instance rootInstance = null;
            for (Instance instance : this.m_adminService.getInstances()) {
                if (!instance.isRoot()) continue;
                rootInstance = instance;
                break;
            }
            if (rootInstance == null) {
                throw new MinionException("Unable to find root instance!");
            }
            try {
                status = rootInstance.getState();
            }
            catch (Exception e) {
                throw new MinionException("Failed to get state from the root container.", (Throwable)e);
            }
        }
        minionStatus.setLocation(this.m_location);
        minionStatus.setStatus(status);
        minionStatus.setDate(new Date());
        return minionStatus;
    }

    protected String loadProperty(String propName) throws MinionException {
        Configuration config = this.getConfiguration();
        Dictionary properties = config.getProperties();
        if (properties == null) {
            return null;
        }
        String property = (String)properties.get(propName);
        return property;
    }

    protected void saveProperty(String key, String value) throws MinionException {
        Configuration config = this.getConfiguration();
        Dictionary properties = config.getProperties() == null ? new Hashtable() : config.getProperties();
        properties.put(key, value);
        try {
            config.update(properties);
        }
        catch (IOException e) {
            MinionException ce = new MinionException("Failed to update configuration.", (Throwable)e);
            LOG.error("Failed to update configuration.", (Throwable)e);
            throw ce;
        }
    }

    protected Configuration getConfiguration() throws MinionException {
        try {
            Configuration configuration = this.m_configurationAdmin.getConfiguration("org.opennms.minion.controller");
            if (configuration == null) {
                MinionException e = new MinionException("The OSGi configuration (admin) registry was found for pid org.opennms.minion.controller, but a configuration could not be located/generated.  This shouldn't happen.");
                LOG.error("Error getting configuration.", (Throwable)e);
                throw e;
            }
            return configuration;
        }
        catch (IOException e) {
            MinionException ce = new MinionException("Failed to get configuration from OSGi configuration registry for pid org.opennms.minion.controller.", (Throwable)e);
            LOG.error("Error getting configuration.", (Throwable)e);
            throw new MinionException((Throwable)ce);
        }
    }

    public void setAdminService(AdminService adminService) {
        this.m_adminService = adminService;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.m_configurationAdmin = configurationAdmin;
    }

    public void setMessageSender(MinionMessageSender sender) {
        this.m_messageSender = sender;
    }

    public void setMessageReceiver(MinionMessageReceiver receiver) {
        this.m_messageReceiver = receiver;
    }

    public void setCamelContext(CamelContext context) {
        this.m_camelContext = context;
    }

    public void setBrokerUri(String brokerUri) {
        this.m_brokerUri = brokerUri;
    }

    public void setSendQueueName(String queue) {
        this.m_sendQueueName = queue;
    }
}

