/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.ECParameterSpec;
import org.apache.sshd.common.digest.MD5;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.BufferUtils;

public class KeyUtils {
    public static String getFingerPrint(PublicKey key) {
        try {
            Buffer buffer = new Buffer();
            buffer.putRawPublicKey(key);
            MD5 md5 = new MD5();
            md5.init();
            md5.update(buffer.array(), 0, buffer.wpos());
            byte[] data = md5.digest();
            return BufferUtils.printHex(data, 0, data.length, ':');
        }
        catch (Exception e) {
            return "Unable to compute fingerprint";
        }
    }

    public static String getKeyType(KeyPair kp) {
        return KeyUtils.getKeyType(kp.getPrivate() != null ? kp.getPrivate() : kp.getPublic());
    }

    public static String getKeyType(Key key) {
        if (key instanceof DSAKey) {
            return "ssh-dss";
        }
        if (key instanceof RSAKey) {
            return "ssh-rsa";
        }
        if (key instanceof ECKey) {
            ECKey ecKey = (ECKey)((Object)key);
            ECParameterSpec ecSpec = ecKey.getParams();
            switch (ecSpec.getCurve().getField().getFieldSize()) {
                case 256: {
                    return "ecdsa-sha2-nistp256";
                }
                case 384: {
                    return "ecdsa-sha2-nistp384";
                }
                case 521: {
                    return "ecdsa-sha2-nistp521";
                }
            }
        }
        return null;
    }

    private KeyUtils() {
    }
}

