/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.api.sample.CollectionRequest;
import org.opennms.netmgt.api.sample.SampleSet;
import org.opennms.netmgt.sampler.config.snmp.Group;
import org.opennms.netmgt.sampler.config.snmp.ResourceType;
import org.opennms.netmgt.sampler.config.snmp.SnmpAgent;
import org.opennms.netmgt.sampler.config.snmp.Table;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

public class SnmpCollectionRequest
implements CollectionRequest<SnmpAgent> {
    private SnmpAgent m_agent;
    private final Map<String, ResourceType> m_typeMap = new HashMap<String, ResourceType>();
    private final Map<String, List<Table>> m_tablesByResourceType = new HashMap<String, List<Table>>();
    private final List<Table> m_tables = new ArrayList<Table>();
    private final List<Group> m_groups = new ArrayList<Group>();

    public SnmpCollectionRequest(SnmpAgent agent) {
        this.m_agent = agent;
    }

    public String getProtocol() {
        return "SNMP";
    }

    public SnmpAgent getAgent() {
        return this.m_agent;
    }

    public SnmpAgentConfig getAgentConfig() throws UnknownHostException {
        InetAddress addr = this.m_agent.getInetAddress();
        SnmpAgentConfig config = new SnmpAgentConfig(addr);
        config.setPort(this.m_agent.getPort());
        config.setVersionAsString(this.m_agent.getVersion());
        config.setReadCommunity(this.m_agent.getCommunity());
        config.setTimeout(this.m_agent.getTimeout());
        config.setRetries(this.m_agent.getRetries());
        return config;
    }

    public void addResourceType(ResourceType resourceType) {
        this.m_typeMap.put(resourceType.getTypeName(), resourceType);
    }

    public void addTable(Table table) {
        List<Table> tables = this.m_tablesByResourceType.get(table.getInstance());
        if (tables == null) {
            tables = new ArrayList<Table>();
            this.m_tablesByResourceType.put(table.getInstance(), tables);
        }
        if (!tables.contains(table)) {
            tables.add(table);
        }
        if (!this.m_tables.contains(table)) {
            this.m_tables.add(table);
        }
    }

    public void addGroup(Group group) {
        this.m_groups.add(group);
    }

    public Collection<ResourceType> getResourceTypes() {
        return this.m_typeMap.values();
    }

    public List<Table> getTables() {
        return this.m_tables;
    }

    public List<Group> getGroups() {
        return this.m_groups;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("SnmpCollectionRequest[");
        buf.append("types=").append(this.getResourceTypes());
        buf.append(", ").append("tables=").append(this.getTables());
        buf.append(", ").append("groups=").append(this.getGroups());
        buf.append("]");
        return buf.toString();
    }

    public CollectionTracker getCollectionTracker(SampleSet sampleSet) {
        ArrayList<CollectionTracker> trackers = new ArrayList<CollectionTracker>();
        for (Table table : this.m_tables) {
            trackers.add(table.createCollectionTracker(this.m_agent, sampleSet));
        }
        for (Group group : this.m_groups) {
            trackers.add(group.createCollectionTracker(this.m_agent, sampleSet));
        }
        return new AggregateTracker(trackers);
    }
}

