/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionConfig;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static Logger LOG = LoggerFactory.getLogger(Parser.class);
    private final Unmarshaller m_unmarshaller = JAXBContext.newInstance((Class[])new Class[]{DataCollectionConfig.class, DataCollectionGroup.class}).createUnmarshaller();
    private String m_username;
    private String m_password;

    public Parser() throws JAXBException {
    }

    public Parser(String username, String password) throws JAXBException {
        this();
        this.m_username = username;
        this.m_password = password;
    }

    public DataCollectionConfig getDataCollectionConfig(URL path) throws JAXBException, IOException {
        return this.parse(path, DataCollectionConfig.class);
    }

    public DataCollectionGroup getDataCollectionGroup(URL path) throws JAXBException, IOException {
        return this.parse(path, DataCollectionGroup.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T parse(URL url, Class<T> declaredType) throws JAXBException, IOException {
        URLConnection connection = url.openConnection();
        try (InputStream urlStream = null;){
            LOG.debug("Unmarshalling {} as {}", (Object)url, declaredType);
            String username = this.m_username;
            String password = this.m_password;
            String userInfo = url.getUserInfo();
            if (userInfo != null && userInfo.contains(":")) {
                String[] auth = userInfo.split(":", 2);
                username = auth[0];
                password = auth[1];
            }
            String basicAuth = "Basic " + new String(new Base64().encode((username + ":" + password).getBytes()));
            connection.setRequestProperty("Authorization", basicAuth);
            connection.connect();
            urlStream = connection.getInputStream();
            JAXBElement jaxbElement = this.m_unmarshaller.unmarshal((Source)new StreamSource(urlStream), declaredType);
            Object object = jaxbElement == null ? null : jaxbElement.getValue();
            return (T)object;
        }
    }
}

